// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Indicates whether the account is compliant with the specified policy. An account is considered noncompliant if it includes resources that are not protected by the policy, for WAF and Shield Advanced policies, or that are noncompliant with the policy, for security group policies.
 */
public class PolicyComplianceStatus private constructor(builder: Builder) {
    /**
     * An array of `EvaluationResult` objects.
     */
    public val evaluationResults: List<EvaluationResult>? = builder.evaluationResults
    /**
     * Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.
     */
    public val issueInfoMap: Map<String, String>? = builder.issueInfoMap
    /**
     * Timestamp of the last update to the `EvaluationResult` objects.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The member account ID.
     */
    public val memberAccount: kotlin.String? = builder.memberAccount
    /**
     * The ID of the Firewall Manager policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The name of the Firewall Manager policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * The Amazon Web Services account that created the Firewall Manager policy.
     */
    public val policyOwner: kotlin.String? = builder.policyOwner

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.PolicyComplianceStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyComplianceStatus(")
        append("evaluationResults=$evaluationResults,")
        append("issueInfoMap=$issueInfoMap,")
        append("lastUpdated=$lastUpdated,")
        append("memberAccount=$memberAccount,")
        append("policyId=$policyId,")
        append("policyName=$policyName,")
        append("policyOwner=$policyOwner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = evaluationResults?.hashCode() ?: 0
        result = 31 * result + (issueInfoMap?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (memberAccount?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyComplianceStatus

        if (evaluationResults != other.evaluationResults) return false
        if (issueInfoMap != other.issueInfoMap) return false
        if (lastUpdated != other.lastUpdated) return false
        if (memberAccount != other.memberAccount) return false
        if (policyId != other.policyId) return false
        if (policyName != other.policyName) return false
        if (policyOwner != other.policyOwner) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.PolicyComplianceStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of `EvaluationResult` objects.
         */
        public var evaluationResults: List<EvaluationResult>? = null
        /**
         * Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.
         */
        public var issueInfoMap: Map<String, String>? = null
        /**
         * Timestamp of the last update to the `EvaluationResult` objects.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The member account ID.
         */
        public var memberAccount: kotlin.String? = null
        /**
         * The ID of the Firewall Manager policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * The name of the Firewall Manager policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * The Amazon Web Services account that created the Firewall Manager policy.
         */
        public var policyOwner: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.PolicyComplianceStatus) : this() {
            this.evaluationResults = x.evaluationResults
            this.issueInfoMap = x.issueInfoMap
            this.lastUpdated = x.lastUpdated
            this.memberAccount = x.memberAccount
            this.policyId = x.policyId
            this.policyName = x.policyName
            this.policyOwner = x.policyOwner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.PolicyComplianceStatus = PolicyComplianceStatus(this)
    }
}
