// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fms.model.AppsListData
import aws.sdk.kotlin.services.fms.model.FmsException
import aws.sdk.kotlin.services.fms.model.GetAppsListResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAppsListOperationDeserializer: HttpDeserialize<GetAppsListResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAppsListResponse {
        if (!response.status.isSuccess()) {
            throwGetAppsListError(context, response)
        }
        val builder = GetAppsListResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAppsListOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAppsListError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAppsListOperationBody(builder: GetAppsListResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AppsList"))
    val APPSLISTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppsListArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPSLIST_DESCRIPTOR)
        field(APPSLISTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPSLIST_DESCRIPTOR.index -> builder.appsList = deserializeAppsListDataDocument(deserializer)
                APPSLISTARN_DESCRIPTOR.index -> builder.appsListArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
