// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.fsx.model.*
import aws.sdk.kotlin.services.fsx.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "FSx"
public const val ServiceApiVersion: String = "2018-03-01"
public const val SdkVersion: String = "0.17.2-beta"

internal class DefaultFSxClient(override val config: FSxClient.Config) : FSxClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
     *
     * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
     */
    override suspend fun associateFileSystemAliases(input: AssociateFileSystemAliasesRequest): AssociateFileSystemAliasesResponse {
        val op = SdkHttpOperation.build<AssociateFileSystemAliasesRequest, AssociateFileSystemAliasesResponse> {
            serializer = AssociateFileSystemAliasesOperationSerializer()
            deserializer = AssociateFileSystemAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateFileSystemAliases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the `PENDING` or `EXECUTING` state. When you cancel a task, Amazon FSx does the following.
     * + Any files that FSx has already exported are not reverted.
     * + FSx continues to export any files that are "in-flight" when the cancel operation is received.
     * + FSx does not export any files that have not yet been exported.
     */
    override suspend fun cancelDataRepositoryTask(input: CancelDataRepositoryTaskRequest): CancelDataRepositoryTaskResponse {
        val op = SdkHttpOperation.build<CancelDataRepositoryTaskRequest, CancelDataRepositoryTaskResponse> {
            serializer = CancelDataRepositoryTaskOperationSerializer()
            deserializer = CancelDataRepositoryTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelDataRepositoryTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.
     *
     * You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: `aws` (Standard Regions), `aws-cn` (China Regions), and `aws-us-gov` (Amazon Web Services GovCloud &#91;US&#93; Regions).
     *
     * You can also use backup copies to clone your file dataset to another Region or within the same Region.
     *
     * You can use the `SourceRegion` parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the `us-west-1` Region and want to copy a backup from the `us-east-2` Region, you specify `us-east-2` in the `SourceRegion` parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).
     *
     * For more information about creating backup copies, see [ Copying backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups) in the *Amazon FSx for Windows User Guide*, [Copying backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups) in the *Amazon FSx for Lustre User Guide*, and [Copying backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups) in the *Amazon FSx for OpenZFS User Guide*.
     */
    override suspend fun copyBackup(input: CopyBackupRequest): CopyBackupResponse {
        val op = SdkHttpOperation.build<CopyBackupRequest, CopyBackupResponse> {
            serializer = CopyBackupOperationSerializer()
            deserializer = CopyBackupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyBackup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.
     *
     * For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:
     * + A Persistent deployment type
     * + Are *not* linked to a data repository
     *
     * For more information about backups, see the following:
     * + For Amazon FSx for Lustre, see [Working with FSx for Lustre backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).
     * + For Amazon FSx for Windows, see [Working with FSx for Windows backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html).
     * + For Amazon FSx for NetApp ONTAP, see [Working with FSx for NetApp ONTAP backups](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html).
     * + For Amazon FSx for OpenZFS, see [Working with FSx for OpenZFS backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html).
     *
     * If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don't match, this operation returns `IncompatibleParameterError`. If a backup with the specified client request token doesn't exist, `CreateBackup` does the following:
     * + Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the backup.
     *
     * By using the idempotent operation, you can retry a `CreateBackup` operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateBackup` operation returns while the backup's lifecycle state is still `CREATING`. You can check the backup creation status by calling the [DescribeBackups](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html) operation, which returns the backup state along with other information.
     */
    override suspend fun createBackup(input: CreateBackupRequest): CreateBackupResponse {
        val op = SdkHttpOperation.build<CreateBackupRequest, CreateBackupResponse> {
            serializer = CreateBackupOperationSerializer()
            deserializer = CreateBackupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     *
     * Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     */
    override suspend fun createDataRepositoryAssociation(input: CreateDataRepositoryAssociationRequest): CreateDataRepositoryAssociationResponse {
        val op = SdkHttpOperation.build<CreateDataRepositoryAssociationRequest, CreateDataRepositoryAssociationResponse> {
            serializer = CreateDataRepositoryAssociationOperationSerializer()
            deserializer = CreateDataRepositoryAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataRepositoryAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations between your Amazon FSx file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository. A `CreateDataRepositoryTask` operation will fail if a data repository is not linked to the FSx file system. To learn more about data repository tasks, see [Data Repository Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html). To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     */
    override suspend fun createDataRepositoryTask(input: CreateDataRepositoryTaskRequest): CreateDataRepositoryTaskResponse {
        val op = SdkHttpOperation.build<CreateDataRepositoryTaskRequest, CreateDataRepositoryTaskResponse> {
            serializer = CreateDataRepositoryTaskOperationSerializer()
            deserializer = CreateDataRepositoryTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataRepositoryTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the `CreateFileSystem` API operation:
     * + Amazon FSx for Lustre
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     *
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.
     *
     * If a file system with the specified client request token exists and the parameters match, `CreateFileSystem` returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, `CreateFileSystem` does the following:
     * + Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system in JSON format.
     *
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport-level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
     *
     * The `CreateFileSystem` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    override suspend fun createFileSystem(input: CreateFileSystemRequest): CreateFileSystemResponse {
        val op = SdkHttpOperation.build<CreateFileSystemRequest, CreateFileSystemResponse> {
            serializer = CreateFileSystemOperationSerializer()
            deserializer = CreateFileSystemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFileSystem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.
     *
     * If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, this operation does the following:
     * + Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system.
     *
     * Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
     *
     * By using the idempotent operation, you can retry a `CreateFileSystemFromBackup` call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
     *
     * The `CreateFileSystemFromBackup` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [ DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    override suspend fun createFileSystemFromBackup(input: CreateFileSystemFromBackupRequest): CreateFileSystemFromBackupResponse {
        val op = SdkHttpOperation.build<CreateFileSystemFromBackupRequest, CreateFileSystemFromBackupResponse> {
            serializer = CreateFileSystemFromBackupOperationSerializer()
            deserializer = CreateFileSystemFromBackupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFileSystemFromBackup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.
     *
     * If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don't match, this operation returns `IncompatibleParameterError`. If a snapshot with the specified client request token doesn't exist, `CreateSnapshot` does the following:
     * + Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the snapshot.
     *
     * By using the idempotent operation, you can retry a `CreateSnapshot` operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateSnapshot` operation returns while the snapshot's lifecycle state is still `CREATING`. You can check the snapshot creation status by calling the [DescribeSnapshots](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html) operation, which returns the snapshot state along with other information.
     */
    override suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse {
        val op = SdkHttpOperation.build<CreateSnapshotRequest, CreateSnapshotResponse> {
            serializer = CreateSnapshotOperationSerializer()
            deserializer = CreateSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
     */
    override suspend fun createStorageVirtualMachine(input: CreateStorageVirtualMachineRequest): CreateStorageVirtualMachineResponse {
        val op = SdkHttpOperation.build<CreateStorageVirtualMachineRequest, CreateStorageVirtualMachineResponse> {
            serializer = CreateStorageVirtualMachineOperationSerializer()
            deserializer = CreateStorageVirtualMachineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStorageVirtualMachine"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
     */
    override suspend fun createVolume(input: CreateVolumeRequest): CreateVolumeResponse {
        val op = SdkHttpOperation.build<CreateVolumeRequest, CreateVolumeResponse> {
            serializer = CreateVolumeOperationSerializer()
            deserializer = CreateVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.
     */
    override suspend fun createVolumeFromBackup(input: CreateVolumeFromBackupRequest): CreateVolumeFromBackupResponse {
        val op = SdkHttpOperation.build<CreateVolumeFromBackupRequest, CreateVolumeFromBackupResponse> {
            serializer = CreateVolumeFromBackupOperationSerializer()
            deserializer = CreateVolumeFromBackupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVolumeFromBackup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.
     *
     * The `DeleteBackup` call returns instantly. The backup won't show up in later `DescribeBackups` calls.
     *
     * The data in a deleted backup is also deleted and can't be recovered by any means.
     */
    override suspend fun deleteBackup(input: DeleteBackupRequest): DeleteBackupResponse {
        val op = SdkHttpOperation.build<DeleteBackupRequest, DeleteBackupResponse> {
            serializer = DeleteBackupOperationSerializer()
            deserializer = DeleteBackupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     */
    override suspend fun deleteDataRepositoryAssociation(input: DeleteDataRepositoryAssociationRequest): DeleteDataRepositoryAssociationResponse {
        val op = SdkHttpOperation.build<DeleteDataRepositoryAssociationRequest, DeleteDataRepositoryAssociationResponse> {
            serializer = DeleteDataRepositoryAssociationOperationSerializer()
            deserializer = DeleteDataRepositoryAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataRepositoryAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.
     *
     * To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a `FileSystemId` value to the `DeleFileSystem` operation.
     *
     * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn't subject to the file system's retention policy, and must be manually deleted.
     *
     * The `DeleteFileSystem` operation returns while the file system has the `DELETING` status. You can check the file system deletion status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the `DescribeFileSystems` operation returns a `FileSystemNotFound` error.
     *
     * If a data repository task is in a `PENDING` or `EXECUTING` state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).
     *
     * The data in a deleted file system is also deleted and can't be recovered by any means.
     */
    override suspend fun deleteFileSystem(input: DeleteFileSystemRequest): DeleteFileSystemResponse {
        val op = SdkHttpOperation.build<DeleteFileSystemRequest, DeleteFileSystemResponse> {
            serializer = DeleteFileSystemOperationSerializer()
            deserializer = DeleteFileSystemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFileSystem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn't affect snapshots stored in a file system backup.
     *
     * The `DeleteSnapshot` operation returns instantly. The snapshot appears with the lifecycle status of `DELETING` until the deletion is complete.
     */
    override suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotRequest, DeleteSnapshotResponse> {
            serializer = DeleteSnapshotOperationSerializer()
            deserializer = DeleteSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.
     */
    override suspend fun deleteStorageVirtualMachine(input: DeleteStorageVirtualMachineRequest): DeleteStorageVirtualMachineResponse {
        val op = SdkHttpOperation.build<DeleteStorageVirtualMachineRequest, DeleteStorageVirtualMachineResponse> {
            serializer = DeleteStorageVirtualMachineOperationSerializer()
            deserializer = DeleteStorageVirtualMachineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStorageVirtualMachine"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    override suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse {
        val op = SdkHttpOperation.build<DeleteVolumeRequest, DeleteVolumeResponse> {
            serializer = DeleteVolumeOperationSerializer()
            deserializer = DeleteVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of a specific Amazon FSx backup, if a `BackupIds` value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all backups, you can optionally specify the `MaxResults` parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of the `NextToken` value from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your backups. `DescribeBackups` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of backup descriptions while still including a `NextToken` value.
     * + The order of the backups returned in the response of one `DescribeBackups` call and the order of the backups returned across the responses of a multi-call iteration is unspecified.
     */
    override suspend fun describeBackups(input: DescribeBackupsRequest): DescribeBackupsResponse {
        val op = SdkHttpOperation.build<DescribeBackupsRequest, DescribeBackupsResponse> {
            serializer = DescribeBackupsOperationSerializer()
            deserializer = DescribeBackupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBackups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx for Lustre data repository associations, if one or more `AssociationIds` values are provided in the request, or if filters are used in the request. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     *
     * You can use filters to narrow the response to include just data repository associations for specific file systems (use the `file-system-id` filter with the ID of the file system) or data repository associations for a specific repository type (use the `data-repository-type` filter with a value of `S3`). If you don't use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all data repository associations, you can paginate the response by using the optional `MaxResults` parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    override suspend fun describeDataRepositoryAssociations(input: DescribeDataRepositoryAssociationsRequest): DescribeDataRepositoryAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeDataRepositoryAssociationsRequest, DescribeDataRepositoryAssociationsResponse> {
            serializer = DescribeDataRepositoryAssociationsOperationSerializer()
            deserializer = DescribeDataRepositoryAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataRepositoryAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more `TaskIds` values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all tasks, you can paginate the response by using the optional `MaxResults` parameter to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    override suspend fun describeDataRepositoryTasks(input: DescribeDataRepositoryTasksRequest): DescribeDataRepositoryTasksResponse {
        val op = SdkHttpOperation.build<DescribeDataRepositoryTasksRequest, DescribeDataRepositoryTasksResponse> {
            serializer = DescribeDataRepositoryTasksOperationSerializer()
            deserializer = DescribeDataRepositoryTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataRepositoryTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the DescribeFileSystems operation response.
     */
    override suspend fun describeFileSystemAliases(input: DescribeFileSystemAliasesRequest): DescribeFileSystemAliasesResponse {
        val op = SdkHttpOperation.build<DescribeFileSystemAliasesRequest, DescribeFileSystemAliasesResponse> {
            serializer = DescribeFileSystemAliasesOperationSerializer()
            deserializer = DescribeFileSystemAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFileSystemAliases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx file systems, if a `FileSystemIds` value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all file system descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your file system descriptions. `DescribeFileSystems` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this operation, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multicall iteration is unspecified.
     */
    override suspend fun describeFileSystems(input: DescribeFileSystemsRequest): DescribeFileSystemsResponse {
        val op = SdkHttpOperation.build<DescribeFileSystemsRequest, DescribeFileSystemsResponse> {
            serializer = DescribeFileSystemsOperationSerializer()
            deserializer = DescribeFileSystemsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFileSystems"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx for OpenZFS snapshots, if a `SnapshotIds` value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all snapshots, you can optionally specify the `MaxResults` parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * Use this operation in an iterative process to retrieve a list of your snapshots. `DescribeSnapshots` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of snapshot descriptions while still including a `NextToken` value.
     * + The order of snapshots returned in the response of one `DescribeSnapshots` call and the order of backups returned across the responses of a multi-call iteration is unspecified.
     */
    override suspend fun describeSnapshots(input: DescribeSnapshotsRequest): DescribeSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotsRequest, DescribeSnapshotsResponse> {
            serializer = DescribeSnapshotsOperationSerializer()
            deserializer = DescribeSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).
     */
    override suspend fun describeStorageVirtualMachines(input: DescribeStorageVirtualMachinesRequest): DescribeStorageVirtualMachinesResponse {
        val op = SdkHttpOperation.build<DescribeStorageVirtualMachinesRequest, DescribeStorageVirtualMachinesResponse> {
            serializer = DescribeStorageVirtualMachinesOperationSerializer()
            deserializer = DescribeStorageVirtualMachinesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStorageVirtualMachines"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.
     */
    override suspend fun describeVolumes(input: DescribeVolumesRequest): DescribeVolumesResponse {
        val op = SdkHttpOperation.build<DescribeVolumesRequest, DescribeVolumesResponse> {
            serializer = DescribeVolumesOperationSerializer()
            deserializer = DescribeVolumesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVolumes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with a 400 Bad Request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
     *
     * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.
     */
    override suspend fun disassociateFileSystemAliases(input: DisassociateFileSystemAliasesRequest): DisassociateFileSystemAliasesResponse {
        val op = SdkHttpOperation.build<DisassociateFileSystemAliasesRequest, DisassociateFileSystemAliasesResponse> {
            serializer = DisassociateFileSystemAliasesOperationSerializer()
            deserializer = DisassociateFileSystemAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFileSystemAliases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists tags for an Amazon FSx file systems and backups in the case of Amazon FSx for Windows File Server.
     *
     * When retrieving all tags, you can optionally specify the `MaxResults` parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This action is used in an iterative process to retrieve a list of your tags. `ListTagsForResource` is called first without a `NextToken`value. Then the action continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this action, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of tags returned in the response of one `ListTagsForResource` call and the order of tags returned across the responses of a multi-call iteration is unspecified.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Releases the file system lock from an Amazon FSx for OpenZFS file system.
     */
    override suspend fun releaseFileSystemNfsV3Locks(input: ReleaseFileSystemNfsV3LocksRequest): ReleaseFileSystemNfsV3LocksResponse {
        val op = SdkHttpOperation.build<ReleaseFileSystemNfsV3LocksRequest, ReleaseFileSystemNfsV3LocksResponse> {
            serializer = ReleaseFileSystemNfsV3LocksOperationSerializer()
            deserializer = ReleaseFileSystemNfsV3LocksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReleaseFileSystemNfsV3Locks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot.
     */
    override suspend fun restoreVolumeFromSnapshot(input: RestoreVolumeFromSnapshotRequest): RestoreVolumeFromSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreVolumeFromSnapshotRequest, RestoreVolumeFromSnapshotResponse> {
            serializer = RestoreVolumeFromSnapshotOperationSerializer()
            deserializer = RestoreVolumeFromSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreVolumeFromSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tags an Amazon FSx resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This action removes a tag from an Amazon FSx resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     */
    override suspend fun updateDataRepositoryAssociation(input: UpdateDataRepositoryAssociationRequest): UpdateDataRepositoryAssociationResponse {
        val op = SdkHttpOperation.build<UpdateDataRepositoryAssociationRequest, UpdateDataRepositoryAssociationResponse> {
            serializer = UpdateDataRepositoryAssociationOperationSerializer()
            deserializer = UpdateDataRepositoryAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataRepositoryAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.
     *
     * For Amazon FSx for Windows File Server file systems, you can update the following properties:
     * + `AuditLogConfiguration`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `SelfManagedActiveDirectoryConfiguration`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For Amazon FSx for Lustre file systems, you can update the following properties:
     * + `AutoImportPolicy`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DataCompressionType`
     * + `LustreRootSquashConfiguration`
     * + `StorageCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For Amazon FSx for NetApp ONTAP file systems, you can update the following properties:
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DiskIopsConfiguration`
     * + `FsxAdminPassword`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For the Amazon FSx for OpenZFS file systems, you can update the following properties:
     * + `AutomaticBackupRetentionDays`
     * + `CopyTagsToBackups`
     * + `CopyTagsToVolumes`
     * + `DailyAutomaticBackupStartTime`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     */
    override suspend fun updateFileSystem(input: UpdateFileSystemRequest): UpdateFileSystemResponse {
        val op = SdkHttpOperation.build<UpdateFileSystemRequest, UpdateFileSystemResponse> {
            serializer = UpdateFileSystemOperationSerializer()
            deserializer = UpdateFileSystemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFileSystem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of an Amazon FSx for OpenZFS snapshot.
     */
    override suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse {
        val op = SdkHttpOperation.build<UpdateSnapshotRequest, UpdateSnapshotResponse> {
            serializer = UpdateSnapshotOperationSerializer()
            deserializer = UpdateSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Amazon FSx for ONTAP storage virtual machine (SVM).
     */
    override suspend fun updateStorageVirtualMachine(input: UpdateStorageVirtualMachineRequest): UpdateStorageVirtualMachineResponse {
        val op = SdkHttpOperation.build<UpdateStorageVirtualMachineRequest, UpdateStorageVirtualMachineResponse> {
            serializer = UpdateStorageVirtualMachineOperationSerializer()
            deserializer = UpdateStorageVirtualMachineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStorageVirtualMachine"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    override suspend fun updateVolume(input: UpdateVolumeRequest): UpdateVolumeResponse {
        val op = SdkHttpOperation.build<UpdateVolumeRequest, UpdateVolumeResponse> {
            serializer = UpdateVolumeOperationSerializer()
            deserializer = UpdateVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fsx"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "fsx")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
