// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.fsx.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.fsx.model.*
import aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesRequest
import aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesResponse
import aws.sdk.kotlin.services.fsx.model.CancelDataRepositoryTaskRequest
import aws.sdk.kotlin.services.fsx.model.CancelDataRepositoryTaskResponse
import aws.sdk.kotlin.services.fsx.model.CopyBackupRequest
import aws.sdk.kotlin.services.fsx.model.CopyBackupResponse
import aws.sdk.kotlin.services.fsx.model.CreateBackupRequest
import aws.sdk.kotlin.services.fsx.model.CreateBackupResponse
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationRequest
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationResponse
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskResponse
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupRequest
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupResponse
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.CreateStorageVirtualMachineRequest
import aws.sdk.kotlin.services.fsx.model.CreateStorageVirtualMachineResponse
import aws.sdk.kotlin.services.fsx.model.CreateVolumeFromBackupRequest
import aws.sdk.kotlin.services.fsx.model.CreateVolumeFromBackupResponse
import aws.sdk.kotlin.services.fsx.model.CreateVolumeRequest
import aws.sdk.kotlin.services.fsx.model.CreateVolumeResponse
import aws.sdk.kotlin.services.fsx.model.DeleteBackupRequest
import aws.sdk.kotlin.services.fsx.model.DeleteBackupResponse
import aws.sdk.kotlin.services.fsx.model.DeleteDataRepositoryAssociationRequest
import aws.sdk.kotlin.services.fsx.model.DeleteDataRepositoryAssociationResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.DeleteSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.DeleteSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.DeleteStorageVirtualMachineRequest
import aws.sdk.kotlin.services.fsx.model.DeleteStorageVirtualMachineResponse
import aws.sdk.kotlin.services.fsx.model.DeleteVolumeRequest
import aws.sdk.kotlin.services.fsx.model.DeleteVolumeResponse
import aws.sdk.kotlin.services.fsx.model.DescribeBackupsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeBackupsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryAssociationsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryAssociationsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryTasksRequest
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryTasksResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemAliasesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemAliasesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeStorageVirtualMachinesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeStorageVirtualMachinesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeVolumesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeVolumesResponse
import aws.sdk.kotlin.services.fsx.model.DisassociateFileSystemAliasesRequest
import aws.sdk.kotlin.services.fsx.model.DisassociateFileSystemAliasesResponse
import aws.sdk.kotlin.services.fsx.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.fsx.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest
import aws.sdk.kotlin.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse
import aws.sdk.kotlin.services.fsx.model.RestoreVolumeFromSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.RestoreVolumeFromSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.TagResourceRequest
import aws.sdk.kotlin.services.fsx.model.TagResourceResponse
import aws.sdk.kotlin.services.fsx.model.UntagResourceRequest
import aws.sdk.kotlin.services.fsx.model.UntagResourceResponse
import aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationRequest
import aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationResponse
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.UpdateSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.UpdateSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.UpdateStorageVirtualMachineRequest
import aws.sdk.kotlin.services.fsx.model.UpdateStorageVirtualMachineResponse
import aws.sdk.kotlin.services.fsx.model.UpdateVolumeRequest
import aws.sdk.kotlin.services.fsx.model.UpdateVolumeResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon FSx is a fully managed service that makes it easy for storage and application administrators to launch and use shared file storage.
 */
public interface FSxClient : SdkClient {

    override val serviceName: String
        get() = "FSx"
    /**
     * FSxClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): FSxClient {
            val config = Config.Builder().apply(block).build()
            return DefaultFSxClient(config)
        }

        public operator fun invoke(config: Config): FSxClient = DefaultFSxClient(config)

        /**
         * Construct a [FSxClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): FSxClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultFSxClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
     *
     * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
     */
    public suspend fun associateFileSystemAliases(input: AssociateFileSystemAliasesRequest): AssociateFileSystemAliasesResponse

    /**
     * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the `PENDING` or `EXECUTING` state. When you cancel a task, Amazon FSx does the following.
     * + Any files that FSx has already exported are not reverted.
     * + FSx continues to export any files that are "in-flight" when the cancel operation is received.
     * + FSx does not export any files that have not yet been exported.
     */
    public suspend fun cancelDataRepositoryTask(input: CancelDataRepositoryTaskRequest): CancelDataRepositoryTaskResponse

    /**
     * Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.
     *
     * You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: `aws` (Standard Regions), `aws-cn` (China Regions), and `aws-us-gov` (Amazon Web Services GovCloud &#91;US&#93; Regions).
     *
     * You can also use backup copies to clone your file dataset to another Region or within the same Region.
     *
     * You can use the `SourceRegion` parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the `us-west-1` Region and want to copy a backup from the `us-east-2` Region, you specify `us-east-2` in the `SourceRegion` parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).
     *
     * For more information about creating backup copies, see [ Copying backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups) in the *Amazon FSx for Windows User Guide*, [Copying backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups) in the *Amazon FSx for Lustre User Guide*, and [Copying backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups) in the *Amazon FSx for OpenZFS User Guide*.
     */
    public suspend fun copyBackup(input: CopyBackupRequest): CopyBackupResponse

    /**
     * Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.
     *
     * For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:
     * + A Persistent deployment type
     * + Are *not* linked to a data repository
     *
     * For more information about backups, see the following:
     * + For Amazon FSx for Lustre, see [Working with FSx for Lustre backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).
     * + For Amazon FSx for Windows, see [Working with FSx for Windows backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html).
     * + For Amazon FSx for NetApp ONTAP, see [Working with FSx for NetApp ONTAP backups](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html).
     * + For Amazon FSx for OpenZFS, see [Working with FSx for OpenZFS backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html).
     *
     * If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don't match, this operation returns `IncompatibleParameterError`. If a backup with the specified client request token doesn't exist, `CreateBackup` does the following:
     * + Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the backup.
     *
     * By using the idempotent operation, you can retry a `CreateBackup` operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateBackup` operation returns while the backup's lifecycle state is still `CREATING`. You can check the backup creation status by calling the [DescribeBackups](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html) operation, which returns the backup state along with other information.
     */
    public suspend fun createBackup(input: CreateBackupRequest = CreateBackupRequest {}): CreateBackupResponse

    /**
     * Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     *
     * Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     */
    public suspend fun createDataRepositoryAssociation(input: CreateDataRepositoryAssociationRequest): CreateDataRepositoryAssociationResponse

    /**
     * Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations between your Amazon FSx file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository. A `CreateDataRepositoryTask` operation will fail if a data repository is not linked to the FSx file system. To learn more about data repository tasks, see [Data Repository Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html). To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     */
    public suspend fun createDataRepositoryTask(input: CreateDataRepositoryTaskRequest): CreateDataRepositoryTaskResponse

    /**
     * Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the `CreateFileSystem` API operation:
     * + Amazon FSx for Lustre
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     *
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.
     *
     * If a file system with the specified client request token exists and the parameters match, `CreateFileSystem` returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, `CreateFileSystem` does the following:
     * + Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system in JSON format.
     *
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport-level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
     *
     * The `CreateFileSystem` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    public suspend fun createFileSystem(input: CreateFileSystemRequest): CreateFileSystemResponse

    /**
     * Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.
     *
     * If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, this operation does the following:
     * + Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system.
     *
     * Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
     *
     * By using the idempotent operation, you can retry a `CreateFileSystemFromBackup` call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
     *
     * The `CreateFileSystemFromBackup` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [ DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    public suspend fun createFileSystemFromBackup(input: CreateFileSystemFromBackupRequest): CreateFileSystemFromBackupResponse

    /**
     * Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.
     *
     * If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don't match, this operation returns `IncompatibleParameterError`. If a snapshot with the specified client request token doesn't exist, `CreateSnapshot` does the following:
     * + Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the snapshot.
     *
     * By using the idempotent operation, you can retry a `CreateSnapshot` operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateSnapshot` operation returns while the snapshot's lifecycle state is still `CREATING`. You can check the snapshot creation status by calling the [DescribeSnapshots](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html) operation, which returns the snapshot state along with other information.
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
     */
    public suspend fun createStorageVirtualMachine(input: CreateStorageVirtualMachineRequest): CreateStorageVirtualMachineResponse

    /**
     * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
     */
    public suspend fun createVolume(input: CreateVolumeRequest): CreateVolumeResponse

    /**
     * Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.
     */
    public suspend fun createVolumeFromBackup(input: CreateVolumeFromBackupRequest): CreateVolumeFromBackupResponse

    /**
     * Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.
     *
     * The `DeleteBackup` call returns instantly. The backup won't show up in later `DescribeBackups` calls.
     *
     * The data in a deleted backup is also deleted and can't be recovered by any means.
     */
    public suspend fun deleteBackup(input: DeleteBackupRequest): DeleteBackupResponse

    /**
     * Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     */
    public suspend fun deleteDataRepositoryAssociation(input: DeleteDataRepositoryAssociationRequest): DeleteDataRepositoryAssociationResponse

    /**
     * Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.
     *
     * To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a `FileSystemId` value to the `DeleFileSystem` operation.
     *
     * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn't subject to the file system's retention policy, and must be manually deleted.
     *
     * The `DeleteFileSystem` operation returns while the file system has the `DELETING` status. You can check the file system deletion status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the `DescribeFileSystems` operation returns a `FileSystemNotFound` error.
     *
     * If a data repository task is in a `PENDING` or `EXECUTING` state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).
     *
     * The data in a deleted file system is also deleted and can't be recovered by any means.
     */
    public suspend fun deleteFileSystem(input: DeleteFileSystemRequest): DeleteFileSystemResponse

    /**
     * Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn't affect snapshots stored in a file system backup.
     *
     * The `DeleteSnapshot` operation returns instantly. The snapshot appears with the lifecycle status of `DELETING` until the deletion is complete.
     */
    public suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.
     */
    public suspend fun deleteStorageVirtualMachine(input: DeleteStorageVirtualMachineRequest): DeleteStorageVirtualMachineResponse

    /**
     * Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    public suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse

    /**
     * Returns the description of a specific Amazon FSx backup, if a `BackupIds` value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all backups, you can optionally specify the `MaxResults` parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of the `NextToken` value from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your backups. `DescribeBackups` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of backup descriptions while still including a `NextToken` value.
     * + The order of the backups returned in the response of one `DescribeBackups` call and the order of the backups returned across the responses of a multi-call iteration is unspecified.
     */
    public suspend fun describeBackups(input: DescribeBackupsRequest = DescribeBackupsRequest {}): DescribeBackupsResponse

    /**
     * Returns the description of specific Amazon FSx for Lustre data repository associations, if one or more `AssociationIds` values are provided in the request, or if filters are used in the request. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     *
     * You can use filters to narrow the response to include just data repository associations for specific file systems (use the `file-system-id` filter with the ID of the file system) or data repository associations for a specific repository type (use the `data-repository-type` filter with a value of `S3`). If you don't use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all data repository associations, you can paginate the response by using the optional `MaxResults` parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    public suspend fun describeDataRepositoryAssociations(input: DescribeDataRepositoryAssociationsRequest = DescribeDataRepositoryAssociationsRequest {}): DescribeDataRepositoryAssociationsResponse

    /**
     * Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more `TaskIds` values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all tasks, you can paginate the response by using the optional `MaxResults` parameter to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    public suspend fun describeDataRepositoryTasks(input: DescribeDataRepositoryTasksRequest = DescribeDataRepositoryTasksRequest {}): DescribeDataRepositoryTasksResponse

    /**
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the DescribeFileSystems operation response.
     */
    public suspend fun describeFileSystemAliases(input: DescribeFileSystemAliasesRequest): DescribeFileSystemAliasesResponse

    /**
     * Returns the description of specific Amazon FSx file systems, if a `FileSystemIds` value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all file system descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your file system descriptions. `DescribeFileSystems` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this operation, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multicall iteration is unspecified.
     */
    public suspend fun describeFileSystems(input: DescribeFileSystemsRequest = DescribeFileSystemsRequest {}): DescribeFileSystemsResponse

    /**
     * Returns the description of specific Amazon FSx for OpenZFS snapshots, if a `SnapshotIds` value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all snapshots, you can optionally specify the `MaxResults` parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * Use this operation in an iterative process to retrieve a list of your snapshots. `DescribeSnapshots` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of snapshot descriptions while still including a `NextToken` value.
     * + The order of snapshots returned in the response of one `DescribeSnapshots` call and the order of backups returned across the responses of a multi-call iteration is unspecified.
     */
    public suspend fun describeSnapshots(input: DescribeSnapshotsRequest = DescribeSnapshotsRequest {}): DescribeSnapshotsResponse

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).
     */
    public suspend fun describeStorageVirtualMachines(input: DescribeStorageVirtualMachinesRequest = DescribeStorageVirtualMachinesRequest {}): DescribeStorageVirtualMachinesResponse

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.
     */
    public suspend fun describeVolumes(input: DescribeVolumesRequest = DescribeVolumesRequest {}): DescribeVolumesResponse

    /**
     * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with a 400 Bad Request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
     *
     * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.
     */
    public suspend fun disassociateFileSystemAliases(input: DisassociateFileSystemAliasesRequest): DisassociateFileSystemAliasesResponse

    /**
     * Lists tags for an Amazon FSx file systems and backups in the case of Amazon FSx for Windows File Server.
     *
     * When retrieving all tags, you can optionally specify the `MaxResults` parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This action is used in an iterative process to retrieve a list of your tags. `ListTagsForResource` is called first without a `NextToken`value. Then the action continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this action, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of tags returned in the response of one `ListTagsForResource` call and the order of tags returned across the responses of a multi-call iteration is unspecified.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Releases the file system lock from an Amazon FSx for OpenZFS file system.
     */
    public suspend fun releaseFileSystemNfsV3Locks(input: ReleaseFileSystemNfsV3LocksRequest): ReleaseFileSystemNfsV3LocksResponse

    /**
     * Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot.
     */
    public suspend fun restoreVolumeFromSnapshot(input: RestoreVolumeFromSnapshotRequest): RestoreVolumeFromSnapshotResponse

    /**
     * Tags an Amazon FSx resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * This action removes a tag from an Amazon FSx resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
     */
    public suspend fun updateDataRepositoryAssociation(input: UpdateDataRepositoryAssociationRequest): UpdateDataRepositoryAssociationResponse

    /**
     * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.
     *
     * For Amazon FSx for Windows File Server file systems, you can update the following properties:
     * + `AuditLogConfiguration`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `SelfManagedActiveDirectoryConfiguration`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For Amazon FSx for Lustre file systems, you can update the following properties:
     * + `AutoImportPolicy`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DataCompressionType`
     * + `LustreRootSquashConfiguration`
     * + `StorageCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For Amazon FSx for NetApp ONTAP file systems, you can update the following properties:
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DiskIopsConfiguration`
     * + `FsxAdminPassword`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For the Amazon FSx for OpenZFS file systems, you can update the following properties:
     * + `AutomaticBackupRetentionDays`
     * + `CopyTagsToBackups`
     * + `CopyTagsToVolumes`
     * + `DailyAutomaticBackupStartTime`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     */
    public suspend fun updateFileSystem(input: UpdateFileSystemRequest): UpdateFileSystemResponse

    /**
     * Updates the name of an Amazon FSx for OpenZFS snapshot.
     */
    public suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse

    /**
     * Updates an Amazon FSx for ONTAP storage virtual machine (SVM).
     */
    public suspend fun updateStorageVirtualMachine(input: UpdateStorageVirtualMachineRequest): UpdateStorageVirtualMachineResponse

    /**
     * Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    public suspend fun updateVolume(input: UpdateVolumeRequest): UpdateVolumeResponse
}

/**
 * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
 *
 * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
 */
public suspend inline fun FSxClient.associateFileSystemAliases(crossinline block: AssociateFileSystemAliasesRequest.Builder.() -> Unit): AssociateFileSystemAliasesResponse = associateFileSystemAliases(AssociateFileSystemAliasesRequest.Builder().apply(block).build())

/**
 * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the `PENDING` or `EXECUTING` state. When you cancel a task, Amazon FSx does the following.
 * + Any files that FSx has already exported are not reverted.
 * + FSx continues to export any files that are "in-flight" when the cancel operation is received.
 * + FSx does not export any files that have not yet been exported.
 */
public suspend inline fun FSxClient.cancelDataRepositoryTask(crossinline block: CancelDataRepositoryTaskRequest.Builder.() -> Unit): CancelDataRepositoryTaskResponse = cancelDataRepositoryTask(CancelDataRepositoryTaskRequest.Builder().apply(block).build())

/**
 * Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.
 *
 * You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: `aws` (Standard Regions), `aws-cn` (China Regions), and `aws-us-gov` (Amazon Web Services GovCloud &#91;US&#93; Regions).
 *
 * You can also use backup copies to clone your file dataset to another Region or within the same Region.
 *
 * You can use the `SourceRegion` parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the `us-west-1` Region and want to copy a backup from the `us-east-2` Region, you specify `us-east-2` in the `SourceRegion` parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).
 *
 * For more information about creating backup copies, see [ Copying backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups) in the *Amazon FSx for Windows User Guide*, [Copying backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups) in the *Amazon FSx for Lustre User Guide*, and [Copying backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups) in the *Amazon FSx for OpenZFS User Guide*.
 */
public suspend inline fun FSxClient.copyBackup(crossinline block: CopyBackupRequest.Builder.() -> Unit): CopyBackupResponse = copyBackup(CopyBackupRequest.Builder().apply(block).build())

/**
 * Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.
 *
 * For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:
 * + A Persistent deployment type
 * + Are *not* linked to a data repository
 *
 * For more information about backups, see the following:
 * + For Amazon FSx for Lustre, see [Working with FSx for Lustre backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).
 * + For Amazon FSx for Windows, see [Working with FSx for Windows backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html).
 * + For Amazon FSx for NetApp ONTAP, see [Working with FSx for NetApp ONTAP backups](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html).
 * + For Amazon FSx for OpenZFS, see [Working with FSx for OpenZFS backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html).
 *
 * If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don't match, this operation returns `IncompatibleParameterError`. If a backup with the specified client request token doesn't exist, `CreateBackup` does the following:
 * + Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the backup.
 *
 * By using the idempotent operation, you can retry a `CreateBackup` operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.
 *
 * The `CreateBackup` operation returns while the backup's lifecycle state is still `CREATING`. You can check the backup creation status by calling the [DescribeBackups](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html) operation, which returns the backup state along with other information.
 */
public suspend inline fun FSxClient.createBackup(crossinline block: CreateBackupRequest.Builder.() -> Unit): CreateBackupResponse = createBackup(CreateBackupRequest.Builder().apply(block).build())

/**
 * Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
 *
 * Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
 */
public suspend inline fun FSxClient.createDataRepositoryAssociation(crossinline block: CreateDataRepositoryAssociationRequest.Builder.() -> Unit): CreateDataRepositoryAssociationResponse = createDataRepositoryAssociation(CreateDataRepositoryAssociationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations between your Amazon FSx file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository. A `CreateDataRepositoryTask` operation will fail if a data repository is not linked to the FSx file system. To learn more about data repository tasks, see [Data Repository Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html). To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
 */
public suspend inline fun FSxClient.createDataRepositoryTask(crossinline block: CreateDataRepositoryTaskRequest.Builder.() -> Unit): CreateDataRepositoryTaskResponse = createDataRepositoryTask(CreateDataRepositoryTaskRequest.Builder().apply(block).build())

/**
 * Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the `CreateFileSystem` API operation:
 * + Amazon FSx for Lustre
 * + Amazon FSx for NetApp ONTAP
 * + Amazon FSx for OpenZFS
 * + Amazon FSx for Windows File Server
 *
 * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.
 *
 * If a file system with the specified client request token exists and the parameters match, `CreateFileSystem` returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, `CreateFileSystem` does the following:
 * + Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the file system in JSON format.
 *
 * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport-level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
 *
 * The `CreateFileSystem` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
 */
public suspend inline fun FSxClient.createFileSystem(crossinline block: CreateFileSystemRequest.Builder.() -> Unit): CreateFileSystemResponse = createFileSystem(CreateFileSystemRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.
 *
 * If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, this operation does the following:
 * + Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the file system.
 *
 * Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
 *
 * By using the idempotent operation, you can retry a `CreateFileSystemFromBackup` call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
 *
 * The `CreateFileSystemFromBackup` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [ DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
 */
public suspend inline fun FSxClient.createFileSystemFromBackup(crossinline block: CreateFileSystemFromBackupRequest.Builder.() -> Unit): CreateFileSystemFromBackupResponse = createFileSystemFromBackup(CreateFileSystemFromBackupRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.
 *
 * If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don't match, this operation returns `IncompatibleParameterError`. If a snapshot with the specified client request token doesn't exist, `CreateSnapshot` does the following:
 * + Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the snapshot.
 *
 * By using the idempotent operation, you can retry a `CreateSnapshot` operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.
 *
 * The `CreateSnapshot` operation returns while the snapshot's lifecycle state is still `CREATING`. You can check the snapshot creation status by calling the [DescribeSnapshots](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html) operation, which returns the snapshot state along with other information.
 */
public suspend inline fun FSxClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
 */
public suspend inline fun FSxClient.createStorageVirtualMachine(crossinline block: CreateStorageVirtualMachineRequest.Builder.() -> Unit): CreateStorageVirtualMachineResponse = createStorageVirtualMachine(CreateStorageVirtualMachineRequest.Builder().apply(block).build())

/**
 * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
 */
public suspend inline fun FSxClient.createVolume(crossinline block: CreateVolumeRequest.Builder.() -> Unit): CreateVolumeResponse = createVolume(CreateVolumeRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.
 */
public suspend inline fun FSxClient.createVolumeFromBackup(crossinline block: CreateVolumeFromBackupRequest.Builder.() -> Unit): CreateVolumeFromBackupResponse = createVolumeFromBackup(CreateVolumeFromBackupRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.
 *
 * The `DeleteBackup` call returns instantly. The backup won't show up in later `DescribeBackups` calls.
 *
 * The data in a deleted backup is also deleted and can't be recovered by any means.
 */
public suspend inline fun FSxClient.deleteBackup(crossinline block: DeleteBackupRequest.Builder.() -> Unit): DeleteBackupResponse = deleteBackup(DeleteBackupRequest.Builder().apply(block).build())

/**
 * Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
 */
public suspend inline fun FSxClient.deleteDataRepositoryAssociation(crossinline block: DeleteDataRepositoryAssociationRequest.Builder.() -> Unit): DeleteDataRepositoryAssociationResponse = deleteDataRepositoryAssociation(DeleteDataRepositoryAssociationRequest.Builder().apply(block).build())

/**
 * Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.
 *
 * To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a `FileSystemId` value to the `DeleFileSystem` operation.
 *
 * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn't subject to the file system's retention policy, and must be manually deleted.
 *
 * The `DeleteFileSystem` operation returns while the file system has the `DELETING` status. You can check the file system deletion status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the `DescribeFileSystems` operation returns a `FileSystemNotFound` error.
 *
 * If a data repository task is in a `PENDING` or `EXECUTING` state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).
 *
 * The data in a deleted file system is also deleted and can't be recovered by any means.
 */
public suspend inline fun FSxClient.deleteFileSystem(crossinline block: DeleteFileSystemRequest.Builder.() -> Unit): DeleteFileSystemResponse = deleteFileSystem(DeleteFileSystemRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn't affect snapshots stored in a file system backup.
 *
 * The `DeleteSnapshot` operation returns instantly. The snapshot appears with the lifecycle status of `DELETING` until the deletion is complete.
 */
public suspend inline fun FSxClient.deleteSnapshot(crossinline block: DeleteSnapshotRequest.Builder.() -> Unit): DeleteSnapshotResponse = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.
 */
public suspend inline fun FSxClient.deleteStorageVirtualMachine(crossinline block: DeleteStorageVirtualMachineRequest.Builder.() -> Unit): DeleteStorageVirtualMachineResponse = deleteStorageVirtualMachine(DeleteStorageVirtualMachineRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
 */
public suspend inline fun FSxClient.deleteVolume(crossinline block: DeleteVolumeRequest.Builder.() -> Unit): DeleteVolumeResponse = deleteVolume(DeleteVolumeRequest.Builder().apply(block).build())

/**
 * Returns the description of a specific Amazon FSx backup, if a `BackupIds` value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all backups, you can optionally specify the `MaxResults` parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of the `NextToken` value from the last response.
 *
 * This operation is used in an iterative process to retrieve a list of your backups. `DescribeBackups` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
 *
 * When using this operation, keep the following in mind:
 * + The operation might return fewer than the `MaxResults` value of backup descriptions while still including a `NextToken` value.
 * + The order of the backups returned in the response of one `DescribeBackups` call and the order of the backups returned across the responses of a multi-call iteration is unspecified.
 */
public suspend inline fun FSxClient.describeBackups(crossinline block: DescribeBackupsRequest.Builder.() -> Unit): DescribeBackupsResponse = describeBackups(DescribeBackupsRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx for Lustre data repository associations, if one or more `AssociationIds` values are provided in the request, or if filters are used in the request. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
 *
 * You can use filters to narrow the response to include just data repository associations for specific file systems (use the `file-system-id` filter with the ID of the file system) or data repository associations for a specific repository type (use the `data-repository-type` filter with a value of `S3`). If you don't use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all data repository associations, you can paginate the response by using the optional `MaxResults` parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 */
public suspend inline fun FSxClient.describeDataRepositoryAssociations(crossinline block: DescribeDataRepositoryAssociationsRequest.Builder.() -> Unit): DescribeDataRepositoryAssociationsResponse = describeDataRepositoryAssociations(DescribeDataRepositoryAssociationsRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more `TaskIds` values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all tasks, you can paginate the response by using the optional `MaxResults` parameter to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 */
public suspend inline fun FSxClient.describeDataRepositoryTasks(crossinline block: DescribeDataRepositoryTasksRequest.Builder.() -> Unit): DescribeDataRepositoryTasksResponse = describeDataRepositoryTasks(DescribeDataRepositoryTasksRequest.Builder().apply(block).build())

/**
 * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the DescribeFileSystems operation response.
 */
public suspend inline fun FSxClient.describeFileSystemAliases(crossinline block: DescribeFileSystemAliasesRequest.Builder.() -> Unit): DescribeFileSystemAliasesResponse = describeFileSystemAliases(DescribeFileSystemAliasesRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx file systems, if a `FileSystemIds` value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all file system descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 *
 * This operation is used in an iterative process to retrieve a list of your file system descriptions. `DescribeFileSystems` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
 *
 * When using this operation, keep the following in mind:
 * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
 * + The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multicall iteration is unspecified.
 */
public suspend inline fun FSxClient.describeFileSystems(crossinline block: DescribeFileSystemsRequest.Builder.() -> Unit): DescribeFileSystemsResponse = describeFileSystems(DescribeFileSystemsRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx for OpenZFS snapshots, if a `SnapshotIds` value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all snapshots, you can optionally specify the `MaxResults` parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 *
 * Use this operation in an iterative process to retrieve a list of your snapshots. `DescribeSnapshots` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
 *
 * When using this operation, keep the following in mind:
 * + The operation might return fewer than the `MaxResults` value of snapshot descriptions while still including a `NextToken` value.
 * + The order of snapshots returned in the response of one `DescribeSnapshots` call and the order of backups returned across the responses of a multi-call iteration is unspecified.
 */
public suspend inline fun FSxClient.describeSnapshots(crossinline block: DescribeSnapshotsRequest.Builder.() -> Unit): DescribeSnapshotsResponse = describeSnapshots(DescribeSnapshotsRequest.Builder().apply(block).build())

/**
 * Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).
 */
public suspend inline fun FSxClient.describeStorageVirtualMachines(crossinline block: DescribeStorageVirtualMachinesRequest.Builder.() -> Unit): DescribeStorageVirtualMachinesResponse = describeStorageVirtualMachines(DescribeStorageVirtualMachinesRequest.Builder().apply(block).build())

/**
 * Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.
 */
public suspend inline fun FSxClient.describeVolumes(crossinline block: DescribeVolumesRequest.Builder.() -> Unit): DescribeVolumesResponse = describeVolumes(DescribeVolumesRequest.Builder().apply(block).build())

/**
 * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with a 400 Bad Request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
 *
 * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.
 */
public suspend inline fun FSxClient.disassociateFileSystemAliases(crossinline block: DisassociateFileSystemAliasesRequest.Builder.() -> Unit): DisassociateFileSystemAliasesResponse = disassociateFileSystemAliases(DisassociateFileSystemAliasesRequest.Builder().apply(block).build())

/**
 * Lists tags for an Amazon FSx file systems and backups in the case of Amazon FSx for Windows File Server.
 *
 * When retrieving all tags, you can optionally specify the `MaxResults` parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 *
 * This action is used in an iterative process to retrieve a list of your tags. `ListTagsForResource` is called first without a `NextToken`value. Then the action continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
 *
 * When using this action, keep the following in mind:
 * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
 * + The order of tags returned in the response of one `ListTagsForResource` call and the order of tags returned across the responses of a multi-call iteration is unspecified.
 */
public suspend inline fun FSxClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Releases the file system lock from an Amazon FSx for OpenZFS file system.
 */
public suspend inline fun FSxClient.releaseFileSystemNfsV3Locks(crossinline block: ReleaseFileSystemNfsV3LocksRequest.Builder.() -> Unit): ReleaseFileSystemNfsV3LocksResponse = releaseFileSystemNfsV3Locks(ReleaseFileSystemNfsV3LocksRequest.Builder().apply(block).build())

/**
 * Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot.
 */
public suspend inline fun FSxClient.restoreVolumeFromSnapshot(crossinline block: RestoreVolumeFromSnapshotRequest.Builder.() -> Unit): RestoreVolumeFromSnapshotResponse = restoreVolumeFromSnapshot(RestoreVolumeFromSnapshotRequest.Builder().apply(block).build())

/**
 * Tags an Amazon FSx resource.
 */
public suspend inline fun FSxClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * This action removes a tag from an Amazon FSx resource.
 */
public suspend inline fun FSxClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
 */
public suspend inline fun FSxClient.updateDataRepositoryAssociation(crossinline block: UpdateDataRepositoryAssociationRequest.Builder.() -> Unit): UpdateDataRepositoryAssociationResponse = updateDataRepositoryAssociation(UpdateDataRepositoryAssociationRequest.Builder().apply(block).build())

/**
 * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.
 *
 * For Amazon FSx for Windows File Server file systems, you can update the following properties:
 * + `AuditLogConfiguration`
 * + `AutomaticBackupRetentionDays`
 * + `DailyAutomaticBackupStartTime`
 * + `SelfManagedActiveDirectoryConfiguration`
 * + `StorageCapacity`
 * + `ThroughputCapacity`
 * + `WeeklyMaintenanceStartTime`
 *
 * For Amazon FSx for Lustre file systems, you can update the following properties:
 * + `AutoImportPolicy`
 * + `AutomaticBackupRetentionDays`
 * + `DailyAutomaticBackupStartTime`
 * + `DataCompressionType`
 * + `LustreRootSquashConfiguration`
 * + `StorageCapacity`
 * + `WeeklyMaintenanceStartTime`
 *
 * For Amazon FSx for NetApp ONTAP file systems, you can update the following properties:
 * + `AutomaticBackupRetentionDays`
 * + `DailyAutomaticBackupStartTime`
 * + `DiskIopsConfiguration`
 * + `FsxAdminPassword`
 * + `StorageCapacity`
 * + `ThroughputCapacity`
 * + `WeeklyMaintenanceStartTime`
 *
 * For the Amazon FSx for OpenZFS file systems, you can update the following properties:
 * + `AutomaticBackupRetentionDays`
 * + `CopyTagsToBackups`
 * + `CopyTagsToVolumes`
 * + `DailyAutomaticBackupStartTime`
 * + `ThroughputCapacity`
 * + `WeeklyMaintenanceStartTime`
 */
public suspend inline fun FSxClient.updateFileSystem(crossinline block: UpdateFileSystemRequest.Builder.() -> Unit): UpdateFileSystemResponse = updateFileSystem(UpdateFileSystemRequest.Builder().apply(block).build())

/**
 * Updates the name of an Amazon FSx for OpenZFS snapshot.
 */
public suspend inline fun FSxClient.updateSnapshot(crossinline block: UpdateSnapshotRequest.Builder.() -> Unit): UpdateSnapshotResponse = updateSnapshot(UpdateSnapshotRequest.Builder().apply(block).build())

/**
 * Updates an Amazon FSx for ONTAP storage virtual machine (SVM).
 */
public suspend inline fun FSxClient.updateStorageVirtualMachine(crossinline block: UpdateStorageVirtualMachineRequest.Builder.() -> Unit): UpdateStorageVirtualMachineResponse = updateStorageVirtualMachine(UpdateStorageVirtualMachineRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
 */
public suspend inline fun FSxClient.updateVolume(crossinline block: UpdateVolumeRequest.Builder.() -> Unit): UpdateVolumeResponse = updateVolume(UpdateVolumeRequest.Builder().apply(block).build())
