// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The Microsoft Active Directory attributes of the Amazon FSx for Windows File Server file system.
 */
public class ActiveDirectoryBackupAttributes private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.
     */
    public val activeDirectoryId: kotlin.String? = builder.activeDirectoryId
    /**
     * The fully qualified domain name of the self-managed Active Directory directory.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveDirectoryBackupAttributes(")
        append("activeDirectoryId=$activeDirectoryId,")
        append("domainName=$domainName,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryId?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActiveDirectoryBackupAttributes

        if (activeDirectoryId != other.activeDirectoryId) return false
        if (domainName != other.domainName) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.
         */
        public var activeDirectoryId: kotlin.String? = null
        /**
         * The fully qualified domain name of the self-managed Active Directory directory.
         */
        public var domainName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes) : this() {
            this.activeDirectoryId = x.activeDirectoryId
            this.domainName = x.domainName
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes = ActiveDirectoryBackupAttributes(this)
    }
}
