// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import kotlin.collections.List

/**
 * Describes the type of administrative action, as follows:
 * + `FILE_SYSTEM_UPDATE` - A file system update administrative action initiated from the Amazon FSx console, API (`UpdateFileSystem`), or CLI (`update-file-system`).
 * + `STORAGE_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's storage capacity has been completed successfully, a `STORAGE_OPTIMIZATION` task starts.
 *    + For Windows and ONTAP, storage optimization is the process of migrating the file system data to newer larger disks.
 *    + For Lustre, storage optimization consists of rebalancing the data across the existing and newly added file servers.
 * You can track the storage-optimization progress using the `ProgressPercent` property. When `STORAGE_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html) in the *Amazon FSx for Windows File Server User Guide*, [Managing storage and throughput capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html) in the *Amazon FSx for Lustre User Guide*, and [Managing storage capacity and provisioned IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
 * + `FILE_SYSTEM_ALIAS_ASSOCIATION` - A file system update to associate a new Domain Name System (DNS) alias with the file system. For more information, see [ AssociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html).
 * + `FILE_SYSTEM_ALIAS_DISASSOCIATION` - A file system update to disassociate a DNS alias from the file system. For more information, see [DisassociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html).
 * + `VOLUME_UPDATE` - A volume update to an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateVolume`), or CLI (`update-volume`).
 * + `SNAPSHOT_UPDATE` - A snapshot update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateSnapshot`), or CLI (`update-snapshot`).
 * + `RELEASE_NFS_V3_LOCKS` - Tracks the release of Network File System (NFS) V3 locks on an Amazon FSx for OpenZFS file system.
 */
public sealed class AdministrativeActionType {

    public abstract val value: kotlin.String

    public object FileSystemAliasAssociation : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "FILE_SYSTEM_ALIAS_ASSOCIATION"
        override fun toString(): kotlin.String = value
    }

    public object FileSystemAliasDisassociation : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "FILE_SYSTEM_ALIAS_DISASSOCIATION"
        override fun toString(): kotlin.String = value
    }

    public object FileSystemUpdate : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "FILE_SYSTEM_UPDATE"
        override fun toString(): kotlin.String = value
    }

    public object ReleaseNfsV3Locks : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "RELEASE_NFS_V3_LOCKS"
        override fun toString(): kotlin.String = value
    }

    public object SnapshotUpdate : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "SNAPSHOT_UPDATE"
        override fun toString(): kotlin.String = value
    }

    public object StorageOptimization : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "STORAGE_OPTIMIZATION"
        override fun toString(): kotlin.String = value
    }

    public object VolumeUpdate : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "VOLUME_UPDATE"
        override fun toString(): kotlin.String = value
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override fun toString(): kotlin.String = value
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(str: kotlin.String): aws.sdk.kotlin.services.fsx.model.AdministrativeActionType = when(str) {
            "FILE_SYSTEM_ALIAS_ASSOCIATION" -> FileSystemAliasAssociation
            "FILE_SYSTEM_ALIAS_DISASSOCIATION" -> FileSystemAliasDisassociation
            "FILE_SYSTEM_UPDATE" -> FileSystemUpdate
            "RELEASE_NFS_V3_LOCKS" -> ReleaseNfsV3Locks
            "SNAPSHOT_UPDATE" -> SnapshotUpdate
            "STORAGE_OPTIMIZATION" -> StorageOptimization
            "VOLUME_UPDATE" -> VolumeUpdate
            else -> SdkUnknown(str)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.fsx.model.AdministrativeActionType> = listOf(
            FileSystemAliasAssociation,
            FileSystemAliasDisassociation,
            FileSystemUpdate,
            ReleaseNfsV3Locks,
            SnapshotUpdate,
            StorageOptimization,
            VolumeUpdate
        )
    }
}
