// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



public class CreateDataRepositoryTaskRequest private constructor(builder: Builder) {
    /**
     * (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is `/mnt/fsx` and `/mnt/fsx/path1` is a directory or file on the file system you want to export, then the path to provide is `path1`. If a path that you provide isn't valid, the task fails.
     */
    public val paths: List<String>? = builder.paths
    /**
     * Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the `Scope` parameter. For more information, see [Working with Task Completion Reports](https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html).
     */
    public val report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = builder.report
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies the type of data repository task to create.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataRepositoryTaskRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("fileSystemId=$fileSystemId,")
        append("paths=$paths,")
        append("report=$report,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (paths?.hashCode() ?: 0)
        result = 31 * result + (report?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataRepositoryTaskRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (fileSystemId != other.fileSystemId) return false
        if (paths != other.paths) return false
        if (report != other.report) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is `/mnt/fsx` and `/mnt/fsx/path1` is a directory or file on the file system you want to export, then the path to provide is `path1`. If a path that you provide isn't valid, the task fails.
         */
        public var paths: List<String>? = null
        /**
         * Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the `Scope` parameter. For more information, see [Working with Task Completion Reports](https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html).
         */
        public var report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies the type of data repository task to create.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.fileSystemId = x.fileSystemId
            this.paths = x.paths
            this.report = x.report
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest = CreateDataRepositoryTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CompletionReport] inside the given [block]
         */
        public fun report(block: aws.sdk.kotlin.services.fsx.model.CompletionReport.Builder.() -> kotlin.Unit) {
            this.report = aws.sdk.kotlin.services.fsx.model.CompletionReport.invoke(block)
        }
    }
}
