// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The request object for the `CreateFileSystemFromBackup` operation.
 */
public class CreateFileSystemFromBackupRequest private constructor(builder: Builder) {
    /**
     * The ID of the source backup. Specifies the backup that you are copying.
     */
    public val backupId: kotlin.String? = builder.backupId
    /**
     * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid values are `2.10` and `2.12`.
     *
     * You don't need to specify `FileSystemTypeVersion` because it will be applied using the backup's `FileSystemTypeVersion` setting. If you choose to specify `FileSystemTypeVersion` when creating from backup, the value must match the backup's `FileSystemTypeVersion` setting.
     */
    public val fileSystemTypeVersion: kotlin.String? = builder.fileSystemTypeVersion
    /**
     * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on Amazon FSx file systems, as follows:
     * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     *
     * If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Lustre configuration for the file system being created.
     *
     * The following parameters are not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
     * + `AutoImportPolicy`
     * + `ExportPath`
     * + `ImportedChunkSize`
     * + `ImportPath`
     */
    public val lustreConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration? = builder.lustreConfiguration
    /**
     * The OpenZFS configuration for the file system that's being created.
     */
    public val openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration? = builder.openZfsConfiguration
    /**
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups apply to all network interfaces. This value isn't returned in later `DescribeFileSystem` requests.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values are `SSD` and `HDD`.
     * + Set to `SSD` to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment types.
     * + Set to `HDD` to use hard disk drive storage. HDD is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` FSx for Windows File Server file system deployment types.
     *
     *  The default value is `SSD`.
     *
     * HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least 2000 GiB.
     */
    public val storageType: aws.sdk.kotlin.services.fsx.model.StorageType? = builder.storageType
    /**
     * Specifies the IDs of the subnets that the file system will be accessible from. For Windows `MULTI_AZ_1` file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the `WindowsConfiguration > PreferredSubnetID` property.
     *
     * Windows `SINGLE_AZ_1` and `SINGLE_AZ_2` file system deployment types, Lustre file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags to be applied to the file system at file system creation. The key value of the `Name` tag appears in the console as the file system name.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The configuration for this Microsoft Windows file system.
     */
    public val windowsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration? = builder.windowsConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemFromBackupRequest(")
        append("backupId=$backupId,")
        append("clientRequestToken=$clientRequestToken,")
        append("fileSystemTypeVersion=$fileSystemTypeVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("lustreConfiguration=$lustreConfiguration,")
        append("openZfsConfiguration=$openZfsConfiguration,")
        append("securityGroupIds=$securityGroupIds,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("windowsConfiguration=$windowsConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupId?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (fileSystemTypeVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lustreConfiguration?.hashCode() ?: 0)
        result = 31 * result + (openZfsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (windowsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemFromBackupRequest

        if (backupId != other.backupId) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (fileSystemTypeVersion != other.fileSystemTypeVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lustreConfiguration != other.lustreConfiguration) return false
        if (openZfsConfiguration != other.openZfsConfiguration) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (windowsConfiguration != other.windowsConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the source backup. Specifies the backup that you are copying.
         */
        public var backupId: kotlin.String? = null
        /**
         * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid values are `2.10` and `2.12`.
         *
         * You don't need to specify `FileSystemTypeVersion` because it will be applied using the backup's `FileSystemTypeVersion` setting. If you choose to specify `FileSystemTypeVersion` when creating from backup, the value must match the backup's `FileSystemTypeVersion` setting.
         */
        public var fileSystemTypeVersion: kotlin.String? = null
        /**
         * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on Amazon FSx file systems, as follows:
         * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
         * + Amazon FSx for NetApp ONTAP
         * + Amazon FSx for OpenZFS
         * + Amazon FSx for Windows File Server
         *
         * If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Lustre configuration for the file system being created.
         *
         * The following parameters are not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
         * + `AutoImportPolicy`
         * + `ExportPath`
         * + `ImportedChunkSize`
         * + `ImportPath`
         */
        public var lustreConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration? = null
        /**
         * The OpenZFS configuration for the file system that's being created.
         */
        public var openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration? = null
        /**
         * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups apply to all network interfaces. This value isn't returned in later `DescribeFileSystem` requests.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values are `SSD` and `HDD`.
         * + Set to `SSD` to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment types.
         * + Set to `HDD` to use hard disk drive storage. HDD is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` FSx for Windows File Server file system deployment types.
         *
         *  The default value is `SSD`.
         *
         * HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least 2000 GiB.
         */
        public var storageType: aws.sdk.kotlin.services.fsx.model.StorageType? = null
        /**
         * Specifies the IDs of the subnets that the file system will be accessible from. For Windows `MULTI_AZ_1` file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the `WindowsConfiguration > PreferredSubnetID` property.
         *
         * Windows `SINGLE_AZ_1` and `SINGLE_AZ_2` file system deployment types, Lustre file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags to be applied to the file system at file system creation. The key value of the `Name` tag appears in the console as the file system name.
         */
        public var tags: List<Tag>? = null
        /**
         * The configuration for this Microsoft Windows file system.
         */
        public var windowsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupRequest) : this() {
            this.backupId = x.backupId
            this.clientRequestToken = x.clientRequestToken
            this.fileSystemTypeVersion = x.fileSystemTypeVersion
            this.kmsKeyId = x.kmsKeyId
            this.lustreConfiguration = x.lustreConfiguration
            this.openZfsConfiguration = x.openZfsConfiguration
            this.securityGroupIds = x.securityGroupIds
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.windowsConfiguration = x.windowsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupRequest = CreateFileSystemFromBackupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration] inside the given [block]
         */
        public fun lustreConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration.Builder.() -> kotlin.Unit) {
            this.lustreConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration] inside the given [block]
         */
        public fun openZfsConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration.Builder.() -> kotlin.Unit) {
            this.openZfsConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration] inside the given [block]
         */
        public fun windowsConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration.Builder.() -> kotlin.Unit) {
            this.windowsConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration.invoke(block)
        }
    }
}
