// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The Lustre configuration for the file system being created.
 *
 * The following parameters are not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
 * + `AutoImportPolicy`
 * + `ExportPath`
 * + `ImportedChunkSize`
 * + `ImportPath`
 */
public class CreateFileSystemLustreConfiguration private constructor(builder: Builder) {
    /**
     * (Optional) Available with `Scratch` and `Persistent_1` deployment types. When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. `AutoImportPolicy` can have the following values:
     * + `NONE` - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.
     * + `NEW` - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.
     * + `NEW_CHANGED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.
     * + `NEW_CHANGED_DELETED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.
     *
     * For more information, see [ Automatically import updates from your S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/older-deployment-types.html#legacy-auto-import-from-s3).
     *
     * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
     */
    public val autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicyType? = builder.autoImportPolicy
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `0`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * (Optional) Not available for use with file systems that are linked to a data repository. A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false. If `CopyTagsToBackups` is set to true, all file system tags are copied to all automatic and user-initiated backups when the user doesn't specify any backup-specific tags. If `CopyTagsToBackups` is set to true and you specify one or more backup tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
     *
     * (Default = `false`)
     *
     * For more information, see [ Working with backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html) in the *Amazon FSx for Lustre User Guide*.
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Sets the data compression configuration for the file system. `DataCompressionType` can have the following values:
     * + `NONE` - (Default) Data compression is turned off when the file system is created.
     * + `LZ4` - Data compression is turned on with the LZ4 algorithm.
     *
     * For more information, see [Lustre data compression](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html) in the *Amazon FSx for Lustre User Guide*.
     */
    public val dataCompressionType: aws.sdk.kotlin.services.fsx.model.DataCompressionType? = builder.dataCompressionType
    /**
     * (Optional) Choose `SCRATCH_1` and `SCRATCH_2` deployment types when you need temporary storage and shorter-term processing of data. The `SCRATCH_2` deployment type provides in-transit encryption of data and higher burst throughput capacity than `SCRATCH_1`.
     *
     * Choose `PERSISTENT_1` for longer-term storage and for throughput-focused workloads that aren’t latency-sensitive. `PERSISTENT_1` supports encryption of data in transit, and is available in all Amazon Web Services Regions in which FSx for Lustre is available.
     *
     * Choose `PERSISTENT_2` for longer-term storage and for latency-sensitive workloads that require the highest levels of IOPS/throughput. `PERSISTENT_2` supports SSD storage, and offers higher `PerUnitStorageThroughput` (up to 1000 MB/s/TiB). `PERSISTENT_2` is available in a limited number of Amazon Web Services Regions. For more information, and an up-to-date list of Amazon Web Services Regions in which `PERSISTENT_2` is available, see [File system deployment options for FSx for Lustre](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html#lustre-deployment-types) in the *Amazon FSx for Lustre User Guide*.
     *
     * If you choose `PERSISTENT_2`, and you set `FileSystemTypeVersion` to `2.10`, the `CreateFileSystem` operation fails.
     *
     * Encryption of data in transit is automatically turned on when you access `SCRATCH_2`, `PERSISTENT_1` and `PERSISTENT_2` file systems from Amazon EC2 instances that [support automatic encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-                 protection.html) in the Amazon Web Services Regions where they are available. For more information about encryption in transit for FSx for Lustre file systems, see [Encrypting data in transit](https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html) in the *Amazon FSx for Lustre User Guide*.
     *
     * (Default = `SCRATCH_1`)
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.LustreDeploymentType? = builder.deploymentType
    /**
     * The type of drive cache used by `PERSISTENT_1` file systems that are provisioned with HDD storage devices. This parameter is required when storage type is HDD. Set this property to `READ` to improve the performance for frequently accessed files by caching up to 20% of the total storage capacity of the file system.
     *
     * This parameter is required when `StorageType` is set to `HDD`.
     */
    public val driveCacheType: aws.sdk.kotlin.services.fsx.model.DriveCacheType? = builder.driveCacheType
    /**
     * (Optional) Available with `Scratch` and `Persistent_1` deployment types. Specifies the path in the Amazon S3 bucket where the root of your Amazon FSx file system is exported. The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and changed data is to be exported from your Amazon FSx for Lustre file system. If an `ExportPath` value is not provided, Amazon FSx sets a default export path, `s3://import-bucket/FSxLustre[creation-timestamp]`. The timestamp is in UTC format, for example `s3://import-bucket/FSxLustre20181105T222312Z`.
     *
     * The Amazon S3 export bucket must be the same as the import bucket specified by `ImportPath`. If you specify only a bucket name, such as `s3://import-bucket`, you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you provide a custom prefix in the export path, such as `s3://import-bucket/[custom-optional-prefix]`, Amazon FSx exports the contents of your file system to that export prefix in the Amazon S3 bucket.
     *
     * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
     */
    public val exportPath: kotlin.String? = builder.exportPath
    /**
     * (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will be mapped to the root of the Amazon S3 bucket you select. An example is `s3://import-bucket/optional-prefix`. If you specify a prefix after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
     *
     * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
     */
    public val importPath: kotlin.String? = builder.importPath
    /**
     * (Optional) For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     *
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
     *
     * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
     */
    public val importedFileChunkSize: kotlin.Int? = builder.importedFileChunkSize
    /**
     * The Lustre logging configuration used when creating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
     */
    public val logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration? = builder.logConfiguration
    /**
     * Required with `PERSISTENT_1` and `PERSISTENT_2` deployment types, provisions the amount of read and write throughput for each 1 tebibyte (TiB) of file system storage capacity, in MB/s/TiB. File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the `PerUnitStorageThroughput` (MB/s/TiB). For a 2.4-TiB ﬁle system, provisioning 50 MB/s/TiB of `PerUnitStorageThroughput` yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you provision.
     *
     * Valid values:
     * + For `PERSISTENT_1` SSD storage: 50, 100, 200 MB/s/TiB.
     * + For `PERSISTENT_1` HDD storage: 12, 40 MB/s/TiB.
     * + For `PERSISTENT_2` SSD storage: 125, 250, 500, 1000 MB/s/TiB.
     */
    public val perUnitStorageThroughput: kotlin.Int? = builder.perUnitStorageThroughput
    /**
     * The Lustre root squash configuration used when creating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
     */
    public val rootSquashConfiguration: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration? = builder.rootSquashConfiguration
    /**
     * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemLustreConfiguration(")
        append("autoImportPolicy=$autoImportPolicy,")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("dataCompressionType=$dataCompressionType,")
        append("deploymentType=$deploymentType,")
        append("driveCacheType=$driveCacheType,")
        append("exportPath=$exportPath,")
        append("importPath=$importPath,")
        append("importedFileChunkSize=$importedFileChunkSize,")
        append("logConfiguration=$logConfiguration,")
        append("perUnitStorageThroughput=$perUnitStorageThroughput,")
        append("rootSquashConfiguration=$rootSquashConfiguration,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoImportPolicy?.hashCode() ?: 0
        result = 31 * result + (automaticBackupRetentionDays ?: 0)
        result = 31 * result + (copyTagsToBackups?.hashCode() ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (dataCompressionType?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (driveCacheType?.hashCode() ?: 0)
        result = 31 * result + (exportPath?.hashCode() ?: 0)
        result = 31 * result + (importPath?.hashCode() ?: 0)
        result = 31 * result + (importedFileChunkSize ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (perUnitStorageThroughput ?: 0)
        result = 31 * result + (rootSquashConfiguration?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemLustreConfiguration

        if (autoImportPolicy != other.autoImportPolicy) return false
        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (dataCompressionType != other.dataCompressionType) return false
        if (deploymentType != other.deploymentType) return false
        if (driveCacheType != other.driveCacheType) return false
        if (exportPath != other.exportPath) return false
        if (importPath != other.importPath) return false
        if (importedFileChunkSize != other.importedFileChunkSize) return false
        if (logConfiguration != other.logConfiguration) return false
        if (perUnitStorageThroughput != other.perUnitStorageThroughput) return false
        if (rootSquashConfiguration != other.rootSquashConfiguration) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * (Optional) Available with `Scratch` and `Persistent_1` deployment types. When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. `AutoImportPolicy` can have the following values:
         * + `NONE` - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.
         * + `NEW` - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system.
         * + `NEW_CHANGED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.
         * + `NEW_CHANGED_DELETED` - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.
         *
         * For more information, see [ Automatically import updates from your S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/older-deployment-types.html#legacy-auto-import-from-s3).
         *
         * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
         */
        public var autoImportPolicy: aws.sdk.kotlin.services.fsx.model.AutoImportPolicyType? = null
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `0`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * (Optional) Not available for use with file systems that are linked to a data repository. A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false. If `CopyTagsToBackups` is set to true, all file system tags are copied to all automatic and user-initiated backups when the user doesn't specify any backup-specific tags. If `CopyTagsToBackups` is set to true and you specify one or more backup tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
         *
         * (Default = `false`)
         *
         * For more information, see [ Working with backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html) in the *Amazon FSx for Lustre User Guide*.
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Sets the data compression configuration for the file system. `DataCompressionType` can have the following values:
         * + `NONE` - (Default) Data compression is turned off when the file system is created.
         * + `LZ4` - Data compression is turned on with the LZ4 algorithm.
         *
         * For more information, see [Lustre data compression](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html) in the *Amazon FSx for Lustre User Guide*.
         */
        public var dataCompressionType: aws.sdk.kotlin.services.fsx.model.DataCompressionType? = null
        /**
         * (Optional) Choose `SCRATCH_1` and `SCRATCH_2` deployment types when you need temporary storage and shorter-term processing of data. The `SCRATCH_2` deployment type provides in-transit encryption of data and higher burst throughput capacity than `SCRATCH_1`.
         *
         * Choose `PERSISTENT_1` for longer-term storage and for throughput-focused workloads that aren’t latency-sensitive. `PERSISTENT_1` supports encryption of data in transit, and is available in all Amazon Web Services Regions in which FSx for Lustre is available.
         *
         * Choose `PERSISTENT_2` for longer-term storage and for latency-sensitive workloads that require the highest levels of IOPS/throughput. `PERSISTENT_2` supports SSD storage, and offers higher `PerUnitStorageThroughput` (up to 1000 MB/s/TiB). `PERSISTENT_2` is available in a limited number of Amazon Web Services Regions. For more information, and an up-to-date list of Amazon Web Services Regions in which `PERSISTENT_2` is available, see [File system deployment options for FSx for Lustre](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html#lustre-deployment-types) in the *Amazon FSx for Lustre User Guide*.
         *
         * If you choose `PERSISTENT_2`, and you set `FileSystemTypeVersion` to `2.10`, the `CreateFileSystem` operation fails.
         *
         * Encryption of data in transit is automatically turned on when you access `SCRATCH_2`, `PERSISTENT_1` and `PERSISTENT_2` file systems from Amazon EC2 instances that [support automatic encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data-                 protection.html) in the Amazon Web Services Regions where they are available. For more information about encryption in transit for FSx for Lustre file systems, see [Encrypting data in transit](https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html) in the *Amazon FSx for Lustre User Guide*.
         *
         * (Default = `SCRATCH_1`)
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.LustreDeploymentType? = null
        /**
         * The type of drive cache used by `PERSISTENT_1` file systems that are provisioned with HDD storage devices. This parameter is required when storage type is HDD. Set this property to `READ` to improve the performance for frequently accessed files by caching up to 20% of the total storage capacity of the file system.
         *
         * This parameter is required when `StorageType` is set to `HDD`.
         */
        public var driveCacheType: aws.sdk.kotlin.services.fsx.model.DriveCacheType? = null
        /**
         * (Optional) Available with `Scratch` and `Persistent_1` deployment types. Specifies the path in the Amazon S3 bucket where the root of your Amazon FSx file system is exported. The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and changed data is to be exported from your Amazon FSx for Lustre file system. If an `ExportPath` value is not provided, Amazon FSx sets a default export path, `s3://import-bucket/FSxLustre[creation-timestamp]`. The timestamp is in UTC format, for example `s3://import-bucket/FSxLustre20181105T222312Z`.
         *
         * The Amazon S3 export bucket must be the same as the import bucket specified by `ImportPath`. If you specify only a bucket name, such as `s3://import-bucket`, you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you provide a custom prefix in the export path, such as `s3://import-bucket/[custom-optional-prefix]`, Amazon FSx exports the contents of your file system to that export prefix in the Amazon S3 bucket.
         *
         * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
         */
        public var exportPath: kotlin.String? = null
        /**
         * (Optional) The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will be mapped to the root of the Amazon S3 bucket you select. An example is `s3://import-bucket/optional-prefix`. If you specify a prefix after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.
         *
         * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
         */
        public var importPath: kotlin.String? = null
        /**
         * (Optional) For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         *
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         *
         * This parameter is not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
         */
        public var importedFileChunkSize: kotlin.Int? = null
        /**
         * The Lustre logging configuration used when creating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
         */
        public var logConfiguration: aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration? = null
        /**
         * Required with `PERSISTENT_1` and `PERSISTENT_2` deployment types, provisions the amount of read and write throughput for each 1 tebibyte (TiB) of file system storage capacity, in MB/s/TiB. File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the `PerUnitStorageThroughput` (MB/s/TiB). For a 2.4-TiB ﬁle system, provisioning 50 MB/s/TiB of `PerUnitStorageThroughput` yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you provision.
         *
         * Valid values:
         * + For `PERSISTENT_1` SSD storage: 50, 100, 200 MB/s/TiB.
         * + For `PERSISTENT_1` HDD storage: 12, 40 MB/s/TiB.
         * + For `PERSISTENT_2` SSD storage: 125, 250, 500, 1000 MB/s/TiB.
         */
        public var perUnitStorageThroughput: kotlin.Int? = null
        /**
         * The Lustre root squash configuration used when creating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
         */
        public var rootSquashConfiguration: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration? = null
        /**
         * (Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration) : this() {
            this.autoImportPolicy = x.autoImportPolicy
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.copyTagsToBackups = x.copyTagsToBackups
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.dataCompressionType = x.dataCompressionType
            this.deploymentType = x.deploymentType
            this.driveCacheType = x.driveCacheType
            this.exportPath = x.exportPath
            this.importPath = x.importPath
            this.importedFileChunkSize = x.importedFileChunkSize
            this.logConfiguration = x.logConfiguration
            this.perUnitStorageThroughput = x.perUnitStorageThroughput
            this.rootSquashConfiguration = x.rootSquashConfiguration
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration = CreateFileSystemLustreConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration] inside the given [block]
         */
        public fun rootSquashConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration.Builder.() -> kotlin.Unit) {
            this.rootSquashConfiguration = aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration.invoke(block)
        }
    }
}
