// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
 */
public class CreateFileSystemOntapConfiguration private constructor(builder: Builder) {
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `0`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Specifies the FSx for ONTAP file system deployment type to use in creating the file system.
     * + `MULTI_AZ_1` - (Default) A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
     * + `SINGLE_AZ_1` - A file system configured for Single-AZ redundancy.
     *
     * For information about the use cases for Multi-AZ and Single-AZ deployments, refer to [Choosing a file system deployment type](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html).
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.OntapDeploymentType? = builder.deploymentType
    /**
     * The SSD IOPS configuration for the FSx for ONTAP file system.
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
     *
     * The Endpoint IP address range you select for your file system must exist outside the VPC's CIDR range and must be at least /30 or larger.
     */
    public val endpointIpAddressRange: kotlin.String? = builder.endpointIpAddressRange
    /**
     * The ONTAP administrative password for the `fsxadmin` user with which you administer your file system using the NetApp ONTAP CLI and REST API.
     */
    public val fsxAdminPassword: kotlin.String? = builder.fsxAdminPassword
    /**
     * Required when `DeploymentType` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
     */
    public val preferredSubnetId: kotlin.String? = builder.preferredSubnetId
    /**
     * (Multi-AZ only) Specifies the virtual private cloud (VPC) route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    public val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * Sets the throughput capacity for the file system that you're creating. Valid values are 128, 256, 512, 1024, and 2048 MBps.
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * A recurring weekly time, in the format `D:HH:MM`.
     *
     * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
     *
     * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
     *
     * For example, `1:05:00` specifies maintenance at 5 AM Monday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemOntapConfiguration(")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("deploymentType=$deploymentType,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("endpointIpAddressRange=$endpointIpAddressRange,")
        append("fsxAdminPassword=*** Sensitive Data Redacted ***,")
        append("preferredSubnetId=$preferredSubnetId,")
        append("routeTableIds=$routeTableIds,")
        append("throughputCapacity=$throughputCapacity,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = automaticBackupRetentionDays ?: 0
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (endpointIpAddressRange?.hashCode() ?: 0)
        result = 31 * result + (fsxAdminPassword?.hashCode() ?: 0)
        result = 31 * result + (preferredSubnetId?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemOntapConfiguration

        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (deploymentType != other.deploymentType) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (endpointIpAddressRange != other.endpointIpAddressRange) return false
        if (fsxAdminPassword != other.fsxAdminPassword) return false
        if (preferredSubnetId != other.preferredSubnetId) return false
        if (routeTableIds != other.routeTableIds) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `0`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Specifies the FSx for ONTAP file system deployment type to use in creating the file system.
         * + `MULTI_AZ_1` - (Default) A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
         * + `SINGLE_AZ_1` - A file system configured for Single-AZ redundancy.
         *
         * For information about the use cases for Multi-AZ and Single-AZ deployments, refer to [Choosing a file system deployment type](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html).
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.OntapDeploymentType? = null
        /**
         * The SSD IOPS configuration for the FSx for ONTAP file system.
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
         *
         * The Endpoint IP address range you select for your file system must exist outside the VPC's CIDR range and must be at least /30 or larger.
         */
        public var endpointIpAddressRange: kotlin.String? = null
        /**
         * The ONTAP administrative password for the `fsxadmin` user with which you administer your file system using the NetApp ONTAP CLI and REST API.
         */
        public var fsxAdminPassword: kotlin.String? = null
        /**
         * Required when `DeploymentType` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
         */
        public var preferredSubnetId: kotlin.String? = null
        /**
         * (Multi-AZ only) Specifies the virtual private cloud (VPC) route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
         */
        public var routeTableIds: List<String>? = null
        /**
         * Sets the throughput capacity for the file system that you're creating. Valid values are 128, 256, 512, 1024, and 2048 MBps.
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * A recurring weekly time, in the format `D:HH:MM`.
         *
         * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
         *
         * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
         *
         * For example, `1:05:00` specifies maintenance at 5 AM Monday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration) : this() {
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.deploymentType = x.deploymentType
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.endpointIpAddressRange = x.endpointIpAddressRange
            this.fsxAdminPassword = x.fsxAdminPassword
            this.preferredSubnetId = x.preferredSubnetId
            this.routeTableIds = x.routeTableIds
            this.throughputCapacity = x.throughputCapacity
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration = CreateFileSystemOntapConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }
    }
}
