// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The request object used to create a new Amazon FSx file system.
 */
public class CreateFileSystemRequest private constructor(builder: Builder) {
    /**
     * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The type of Amazon FSx file system to create. Valid values are `WINDOWS`, `LUSTRE`, `ONTAP`, and `OPENZFS`.
     */
    public val fileSystemType: aws.sdk.kotlin.services.fsx.model.FileSystemType? = builder.fileSystemType
    /**
     * (Optional) For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating. Valid values are `2.10` and `2.12`:
     * + 2.10 is supported by the Scratch and Persistent_1 Lustre deployment types.
     * + 2.12 is supported by all Lustre deployment types. `2.12` is required when setting FSx for Lustre `DeploymentType` to `PERSISTENT_2`.
     *
     * Default value = `2.10`, except when `DeploymentType` is set to `PERSISTENT_2`, then the default is `2.12`.
     *
     * If you set `FileSystemTypeVersion` to `2.10` for a `PERSISTENT_2` Lustre deployment type, the `CreateFileSystem` operation fails.
     */
    public val fileSystemTypeVersion: kotlin.String? = builder.fileSystemTypeVersion
    /**
     * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on Amazon FSx file systems, as follows:
     * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     *
     * If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Lustre configuration for the file system being created.
     *
     * The following parameters are not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
     * + `AutoImportPolicy`
     * + `ExportPath`
     * + `ImportedChunkSize`
     * + `ImportPath`
     */
    public val lustreConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration? = builder.lustreConfiguration
    /**
     * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
     */
    public val ontapConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration? = builder.ontapConfiguration
    /**
     * The OpenZFS configuration for the file system that's being created.
     */
    public val openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration? = builder.openZfsConfiguration
    /**
     * A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This list isn't returned in later requests to describe the file system.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Sets the storage capacity of the file system that you're creating, in gibibytes (GiB).
     *
     * **FSx for Lustre file systems** - The amount of storage capacity that you can configure depends on the value that you set for `StorageType` and the Lustre `DeploymentType`, as follows:
     * + For `SCRATCH_2`, `PERSISTENT_2` and `PERSISTENT_1` deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.
     * + For `PERSISTENT_1` HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.
     * + For `SCRATCH_1` deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.
     *
     * **FSx for ONTAP file systems** - The amount of storage capacity that you can configure is from 1024 GiB up to 196,608 GiB (192 TiB).
     *
     * **FSx for OpenZFS file systems** - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB).
     *
     * **FSx for Windows File Server file systems** - The amount of storage capacity that you can configure depends on the value that you set for `StorageType` as follows:
     * + For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).
     * + For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).
     */
    public val storageCapacity: kotlin.Int? = builder.storageCapacity
    /**
     * Sets the storage type for the file system that you're creating. Valid values are `SSD` and `HDD`.
     * + Set to `SSD` to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.
     * + Set to `HDD` to use hard disk drive storage. HDD is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types, and on `PERSISTENT_1` Lustre file system deployment types.
     *
     * Default value is `SSD`. For more information, see [ Storage type options](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options) in the *FSx for Windows File Server User Guide* and [Multiple storage options](https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options) in the *FSx for Lustre User Guide*.
     */
    public val storageType: aws.sdk.kotlin.services.fsx.model.StorageType? = builder.storageType
    /**
     * Specifies the IDs of the subnets that the file system will be accessible from. For Windows and ONTAP `MULTI_AZ_1` deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the `WindowsConfiguration > PreferredSubnetID` or `OntapConfiguration > PreferredSubnetID` properties. For more information about Multi-AZ file system configuration, see [ Availability and durability: Single-AZ and Multi-AZ file systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html) in the *Amazon FSx for Windows User Guide* and [ Availability and durability](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html) in the *Amazon FSx for ONTAP User Guide*.
     *
     * For Windows `SINGLE_AZ_1` and `SINGLE_AZ_2` and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags to apply to the file system that's being created. The key value of the `Name` tag appears in the console as the file system name.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Microsoft Windows configuration for the file system that's being created.
     */
    public val windowsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration? = builder.windowsConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("fileSystemType=$fileSystemType,")
        append("fileSystemTypeVersion=$fileSystemTypeVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("lustreConfiguration=$lustreConfiguration,")
        append("ontapConfiguration=$ontapConfiguration,")
        append("openZfsConfiguration=$openZfsConfiguration,")
        append("securityGroupIds=$securityGroupIds,")
        append("storageCapacity=$storageCapacity,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("windowsConfiguration=$windowsConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (fileSystemType?.hashCode() ?: 0)
        result = 31 * result + (fileSystemTypeVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lustreConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ontapConfiguration?.hashCode() ?: 0)
        result = 31 * result + (openZfsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (storageCapacity ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (windowsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (fileSystemType != other.fileSystemType) return false
        if (fileSystemTypeVersion != other.fileSystemTypeVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lustreConfiguration != other.lustreConfiguration) return false
        if (ontapConfiguration != other.ontapConfiguration) return false
        if (openZfsConfiguration != other.openZfsConfiguration) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (storageCapacity != other.storageCapacity) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (windowsConfiguration != other.windowsConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileSystemRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The type of Amazon FSx file system to create. Valid values are `WINDOWS`, `LUSTRE`, `ONTAP`, and `OPENZFS`.
         */
        public var fileSystemType: aws.sdk.kotlin.services.fsx.model.FileSystemType? = null
        /**
         * (Optional) For FSx for Lustre file systems, sets the Lustre version for the file system that you're creating. Valid values are `2.10` and `2.12`:
         * + 2.10 is supported by the Scratch and Persistent_1 Lustre deployment types.
         * + 2.12 is supported by all Lustre deployment types. `2.12` is required when setting FSx for Lustre `DeploymentType` to `PERSISTENT_2`.
         *
         * Default value = `2.10`, except when `DeploymentType` is set to `PERSISTENT_2`, then the default is `2.12`.
         *
         * If you set `FileSystemTypeVersion` to `2.10` for a `PERSISTENT_2` Lustre deployment type, the `CreateFileSystem` operation fails.
         */
        public var fileSystemTypeVersion: kotlin.String? = null
        /**
         * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on Amazon FSx file systems, as follows:
         * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
         * + Amazon FSx for NetApp ONTAP
         * + Amazon FSx for OpenZFS
         * + Amazon FSx for Windows File Server
         *
         * If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Lustre configuration for the file system being created.
         *
         * The following parameters are not supported for file systems with the `Persistent_2` deployment type. Instead, use `CreateDataRepositoryAssociation` to create a data repository association to link your Lustre file system to a data repository.
         * + `AutoImportPolicy`
         * + `ExportPath`
         * + `ImportedChunkSize`
         * + `ImportPath`
         */
        public var lustreConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration? = null
        /**
         * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
         */
        public var ontapConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration? = null
        /**
         * The OpenZFS configuration for the file system that's being created.
         */
        public var openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration? = null
        /**
         * A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This list isn't returned in later requests to describe the file system.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * Sets the storage capacity of the file system that you're creating, in gibibytes (GiB).
         *
         * **FSx for Lustre file systems** - The amount of storage capacity that you can configure depends on the value that you set for `StorageType` and the Lustre `DeploymentType`, as follows:
         * + For `SCRATCH_2`, `PERSISTENT_2` and `PERSISTENT_1` deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.
         * + For `PERSISTENT_1` HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.
         * + For `SCRATCH_1` deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.
         *
         * **FSx for ONTAP file systems** - The amount of storage capacity that you can configure is from 1024 GiB up to 196,608 GiB (192 TiB).
         *
         * **FSx for OpenZFS file systems** - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB).
         *
         * **FSx for Windows File Server file systems** - The amount of storage capacity that you can configure depends on the value that you set for `StorageType` as follows:
         * + For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).
         * + For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).
         */
        public var storageCapacity: kotlin.Int? = null
        /**
         * Sets the storage type for the file system that you're creating. Valid values are `SSD` and `HDD`.
         * + Set to `SSD` to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.
         * + Set to `HDD` to use hard disk drive storage. HDD is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types, and on `PERSISTENT_1` Lustre file system deployment types.
         *
         * Default value is `SSD`. For more information, see [ Storage type options](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options) in the *FSx for Windows File Server User Guide* and [Multiple storage options](https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options) in the *FSx for Lustre User Guide*.
         */
        public var storageType: aws.sdk.kotlin.services.fsx.model.StorageType? = null
        /**
         * Specifies the IDs of the subnets that the file system will be accessible from. For Windows and ONTAP `MULTI_AZ_1` deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the `WindowsConfiguration > PreferredSubnetID` or `OntapConfiguration > PreferredSubnetID` properties. For more information about Multi-AZ file system configuration, see [ Availability and durability: Single-AZ and Multi-AZ file systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html) in the *Amazon FSx for Windows User Guide* and [ Availability and durability](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html) in the *Amazon FSx for ONTAP User Guide*.
         *
         * For Windows `SINGLE_AZ_1` and `SINGLE_AZ_2` and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags to apply to the file system that's being created. The key value of the `Name` tag appears in the console as the file system name.
         */
        public var tags: List<Tag>? = null
        /**
         * The Microsoft Windows configuration for the file system that's being created.
         */
        public var windowsConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileSystemRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.fileSystemType = x.fileSystemType
            this.fileSystemTypeVersion = x.fileSystemTypeVersion
            this.kmsKeyId = x.kmsKeyId
            this.lustreConfiguration = x.lustreConfiguration
            this.ontapConfiguration = x.ontapConfiguration
            this.openZfsConfiguration = x.openZfsConfiguration
            this.securityGroupIds = x.securityGroupIds
            this.storageCapacity = x.storageCapacity
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.windowsConfiguration = x.windowsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileSystemRequest = CreateFileSystemRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration] inside the given [block]
         */
        public fun lustreConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration.Builder.() -> kotlin.Unit) {
            this.lustreConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration] inside the given [block]
         */
        public fun ontapConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration.Builder.() -> kotlin.Unit) {
            this.ontapConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration] inside the given [block]
         */
        public fun openZfsConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration.Builder.() -> kotlin.Unit) {
            this.openZfsConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration] inside the given [block]
         */
        public fun windowsConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration.Builder.() -> kotlin.Unit) {
            this.windowsConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration.invoke(block)
        }
    }
}
