// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * Specifies the configuration of the ONTAP volume that you are creating.
 */
public class CreateOntapVolumeConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the location in the SVM's namespace where the volume is mounted. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
     */
    public val junctionPath: kotlin.String? = builder.junctionPath
    /**
     * The security style for the volume. Specify one of the following values:
     * + `UNIX` if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account. `UNIX` is the default.
     * + `NTFS` if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.
     * + `MIXED` if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.
     */
    public val securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = builder.securityStyle
    /**
     * Specifies the size of the volume, in megabytes (MB), that you are creating.
     */
    public val sizeInMegabytes: kotlin.Int? = builder.sizeInMegabytes
    /**
     * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     */
    public val storageEfficiencyEnabled: kotlin.Boolean? = builder.storageEfficiencyEnabled
    /**
     * Specifies the ONTAP SVM in which to create the volume.
     */
    public val storageVirtualMachineId: kotlin.String? = builder.storageVirtualMachineId
    /**
     * Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
     *
     * Valid tiering policies are the following:
     * + `SNAPSHOT_ONLY` - (Default value) moves cold snapshots to the capacity pool storage tier.
     *
     * + `AUTO` - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.
     *
     * + `ALL` - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.
     *
     * + `NONE` - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.
     */
    public val tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = builder.tieringPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOntapVolumeConfiguration(")
        append("junctionPath=$junctionPath,")
        append("securityStyle=$securityStyle,")
        append("sizeInMegabytes=$sizeInMegabytes,")
        append("storageEfficiencyEnabled=$storageEfficiencyEnabled,")
        append("storageVirtualMachineId=$storageVirtualMachineId,")
        append("tieringPolicy=$tieringPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = junctionPath?.hashCode() ?: 0
        result = 31 * result + (securityStyle?.hashCode() ?: 0)
        result = 31 * result + (sizeInMegabytes ?: 0)
        result = 31 * result + (storageEfficiencyEnabled?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineId?.hashCode() ?: 0)
        result = 31 * result + (tieringPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOntapVolumeConfiguration

        if (junctionPath != other.junctionPath) return false
        if (securityStyle != other.securityStyle) return false
        if (sizeInMegabytes != other.sizeInMegabytes) return false
        if (storageEfficiencyEnabled != other.storageEfficiencyEnabled) return false
        if (storageVirtualMachineId != other.storageVirtualMachineId) return false
        if (tieringPolicy != other.tieringPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the location in the SVM's namespace where the volume is mounted. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
         */
        public var junctionPath: kotlin.String? = null
        /**
         * The security style for the volume. Specify one of the following values:
         * + `UNIX` if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account. `UNIX` is the default.
         * + `NTFS` if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.
         * + `MIXED` if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.
         */
        public var securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = null
        /**
         * Specifies the size of the volume, in megabytes (MB), that you are creating.
         */
        public var sizeInMegabytes: kotlin.Int? = null
        /**
         * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
         */
        public var storageEfficiencyEnabled: kotlin.Boolean? = null
        /**
         * Specifies the ONTAP SVM in which to create the volume.
         */
        public var storageVirtualMachineId: kotlin.String? = null
        /**
         * Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
         *
         * Valid tiering policies are the following:
         * + `SNAPSHOT_ONLY` - (Default value) moves cold snapshots to the capacity pool storage tier.
         *
         * + `AUTO` - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.
         *
         * + `ALL` - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.
         *
         * + `NONE` - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.
         */
        public var tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration) : this() {
            this.junctionPath = x.junctionPath
            this.securityStyle = x.securityStyle
            this.sizeInMegabytes = x.sizeInMegabytes
            this.storageEfficiencyEnabled = x.storageEfficiencyEnabled
            this.storageVirtualMachineId = x.storageVirtualMachineId
            this.tieringPolicy = x.tieringPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration = CreateOntapVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.TieringPolicy] inside the given [block]
         */
        public fun tieringPolicy(block: aws.sdk.kotlin.services.fsx.model.TieringPolicy.Builder.() -> kotlin.Unit) {
            this.tieringPolicy = aws.sdk.kotlin.services.fsx.model.TieringPolicy.invoke(block)
        }
    }
}
