// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration that Amazon FSx uses to join the ONTAP storage virtual machine (SVM) to your self-managed (including on-premises) Microsoft Active Directory (AD) directory.
 */
public class CreateSvmActiveDirectoryConfiguration private constructor(builder: Builder) {
    /**
     * The NetBIOS name of the Active Directory computer object that will be created for your SVM.
     */
    public val netBiosName: kotlin.String? = builder.netBiosName
    /**
     * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory. For more information, see [ Using Amazon FSx with your self-managed Microsoft Active Directory](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or [Managing SVMs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
     */
    public val selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration? = builder.selfManagedActiveDirectoryConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateSvmActiveDirectoryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSvmActiveDirectoryConfiguration(")
        append("netBiosName=$netBiosName,")
        append("selfManagedActiveDirectoryConfiguration=$selfManagedActiveDirectoryConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = netBiosName?.hashCode() ?: 0
        result = 31 * result + (selfManagedActiveDirectoryConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSvmActiveDirectoryConfiguration

        if (netBiosName != other.netBiosName) return false
        if (selfManagedActiveDirectoryConfiguration != other.selfManagedActiveDirectoryConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateSvmActiveDirectoryConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The NetBIOS name of the Active Directory computer object that will be created for your SVM.
         */
        public var netBiosName: kotlin.String? = null
        /**
         * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory. For more information, see [ Using Amazon FSx with your self-managed Microsoft Active Directory](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or [Managing SVMs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
         */
        public var selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateSvmActiveDirectoryConfiguration) : this() {
            this.netBiosName = x.netBiosName
            this.selfManagedActiveDirectoryConfiguration = x.selfManagedActiveDirectoryConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateSvmActiveDirectoryConfiguration = CreateSvmActiveDirectoryConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration] inside the given [block]
         */
        public fun selfManagedActiveDirectoryConfiguration(block: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration.Builder.() -> kotlin.Unit) {
            this.selfManagedActiveDirectoryConfiguration = aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration.invoke(block)
        }
    }
}
