// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration of a data repository association that links an Amazon FSx for Lustre file system to an Amazon S3 bucket. The data repository association configuration object is returned in the response of the following operations:
 * + `CreateDataRepositoryAssociation`
 * + `UpdateDataRepositoryAssociation`
 * + `DescribeDataRepositoryAssociations`
 *
 * Data repository associations are supported only for file systems with the `Persistent_2` deployment type.
 */
public class DataRepositoryAssociation private constructor(builder: Builder) {
    /**
     * The system-generated, unique ID of the data repository association.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to `true`.
     */
    public val batchImportMetaDataOnCreate: kotlin.Boolean? = builder.batchImportMetaDataOnCreate
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format `s3://myBucket/myPrefix/`. This path specifies where in the S3 data repository files will be imported from or exported to.
     */
    public val dataRepositoryPath: kotlin.String? = builder.dataRepositoryPath
    /**
     * Provides detailed information about the data respository if its `Lifecycle` is set to `MISCONFIGURED` or `FAILED`.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails? = builder.failureDetails
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`.
     *
     * This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     *
     * If you specify only a forward slash (`/`) as the file system path, you can link only 1 data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
     */
    public val fileSystemPath: kotlin.String? = builder.fileSystemPath
    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     *
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
     */
    public val importedFileChunkSize: kotlin.Int? = builder.importedFileChunkSize
    /**
     * Describes the state of a data repository association. The lifecycle can have the following values:
     * + `CREATING` - The data repository association between the FSx file system and the S3 data repository is being created. The data repository is unavailable.
     * + `AVAILABLE` - The data repository association is available for use.
     * + `MISCONFIGURED` - Amazon FSx cannot automatically import updates from the S3 bucket or automatically export updates to the S3 bucket until the data repository association configuration is corrected.
     * + `UPDATING` - The data repository association is undergoing a customer initiated update that might affect its availability.
     * + `DELETING` - The data repository association is undergoing a customer initiated deletion.
     * + `FAILED` - The data repository association is in a terminal state that cannot be recovered.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryLifecycle? = builder.lifecycle
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     */
    public val s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = builder.s3
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataRepositoryAssociation(")
        append("associationId=$associationId,")
        append("batchImportMetaDataOnCreate=$batchImportMetaDataOnCreate,")
        append("creationTime=$creationTime,")
        append("dataRepositoryPath=$dataRepositoryPath,")
        append("failureDetails=$failureDetails,")
        append("fileSystemId=$fileSystemId,")
        append("fileSystemPath=$fileSystemPath,")
        append("importedFileChunkSize=$importedFileChunkSize,")
        append("lifecycle=$lifecycle,")
        append("resourceArn=$resourceArn,")
        append("s3=$s3,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (batchImportMetaDataOnCreate?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataRepositoryPath?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (fileSystemPath?.hashCode() ?: 0)
        result = 31 * result + (importedFileChunkSize ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (s3?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataRepositoryAssociation

        if (associationId != other.associationId) return false
        if (batchImportMetaDataOnCreate != other.batchImportMetaDataOnCreate) return false
        if (creationTime != other.creationTime) return false
        if (dataRepositoryPath != other.dataRepositoryPath) return false
        if (failureDetails != other.failureDetails) return false
        if (fileSystemId != other.fileSystemId) return false
        if (fileSystemPath != other.fileSystemPath) return false
        if (importedFileChunkSize != other.importedFileChunkSize) return false
        if (lifecycle != other.lifecycle) return false
        if (resourceArn != other.resourceArn) return false
        if (s3 != other.s3) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The system-generated, unique ID of the data repository association.
         */
        public var associationId: kotlin.String? = null
        /**
         * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to `true`.
         */
        public var batchImportMetaDataOnCreate: kotlin.Boolean? = null
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format `s3://myBucket/myPrefix/`. This path specifies where in the S3 data repository files will be imported from or exported to.
         */
        public var dataRepositoryPath: kotlin.String? = null
        /**
         * Provides detailed information about the data respository if its `Lifecycle` is set to `MISCONFIGURED` or `FAILED`.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`.
         *
         * This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
         *
         * If you specify only a forward slash (`/`) as the file system path, you can link only 1 data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
         */
        public var fileSystemPath: kotlin.String? = null
        /**
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         *
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         */
        public var importedFileChunkSize: kotlin.Int? = null
        /**
         * Describes the state of a data repository association. The lifecycle can have the following values:
         * + `CREATING` - The data repository association between the FSx file system and the S3 data repository is being created. The data repository is unavailable.
         * + `AVAILABLE` - The data repository association is available for use.
         * + `MISCONFIGURED` - Amazon FSx cannot automatically import updates from the S3 bucket or automatically export updates to the S3 bucket until the data repository association configuration is corrected.
         * + `UPDATING` - The data repository association is undergoing a customer initiated update that might affect its availability.
         * + `DELETING` - The data repository association is undergoing a customer initiated deletion.
         * + `FAILED` - The data repository association is in a terminal state that cannot be recovered.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryLifecycle? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
         */
        public var s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation) : this() {
            this.associationId = x.associationId
            this.batchImportMetaDataOnCreate = x.batchImportMetaDataOnCreate
            this.creationTime = x.creationTime
            this.dataRepositoryPath = x.dataRepositoryPath
            this.failureDetails = x.failureDetails
            this.fileSystemId = x.fileSystemId
            this.fileSystemPath = x.fileSystemPath
            this.importedFileChunkSize = x.importedFileChunkSize
            this.lifecycle = x.lifecycle
            this.resourceArn = x.resourceArn
            this.s3 = x.s3
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation = DataRepositoryAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration] inside the given [block]
         */
        public fun s3(block: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.Builder.() -> kotlin.Unit) {
            this.s3 = aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.invoke(block)
        }
    }
}
