// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A description of the data repository task. You use data repository tasks to perform bulk transfer operations between your Amazon FSx file system and a linked data repository.
 */
public class DataRepositoryTask private constructor(builder: Builder) {
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time that Amazon FSx completed processing the task, populated after the task is complete.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Failure message describing why the task failed, it is populated only when `Lifecycle` is set to `FAILED`.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails? = builder.failureDetails
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The lifecycle status of the data repository task, as follows:
     * + `PENDING` - Amazon FSx has not started the task.
     * + `EXECUTING` - Amazon FSx is processing the task.
     * + `FAILED` - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The DataRepositoryTaskFailureDetails property provides more information about task failures.
     * + `SUCCEEDED` - FSx completed the task successfully.
     * + `CANCELED` - Amazon FSx canceled the task and it did not complete.
     * + `CANCELING` - FSx is in process of canceling the task.
     *
     * You cannot delete an FSx for Lustre file system if there are data repository tasks for the file system in the `PENDING` or `EXECUTING` states. Please retry when the data repository task is finished (with a status of `CANCELED`, `SUCCEEDED`, or `FAILED`). You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskLifecycle? = builder.lifecycle
    /**
     * An array of paths on the Amazon FSx for Lustre file system that specify the data for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.
     *
     * (Default) If `Paths` is not specified, Amazon FSx uses the file system root directory.
     */
    public val paths: List<String>? = builder.paths
    /**
     * Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report `Scope` parameter. FSx delivers the report to the file system's linked data repository in Amazon S3, using the path specified in the report `Path` parameter. You can specify whether or not a report gets generated for a task using the `Enabled` parameter.
     */
    public val report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = builder.report
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The time that Amazon FSx began processing the task.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Provides the status of the number of files that the task has processed successfully and failed to process.
     */
    public val status: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus? = builder.status
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The system-generated, unique 17-digit ID of the data repository task.
     */
    public val taskId: kotlin.String? = builder.taskId
    /**
     * The type of data repository task.
     * + The `EXPORT_TO_REPOSITORY` data repository task exports from your Lustre file system from to a linked S3 bucket.
     * + The `IMPORT_METADATA_FROM_REPOSITORY` data repository task imports metadata changes from a linked S3 bucket to your Lustre file system.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DataRepositoryTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataRepositoryTask(")
        append("creationTime=$creationTime,")
        append("endTime=$endTime,")
        append("failureDetails=$failureDetails,")
        append("fileSystemId=$fileSystemId,")
        append("lifecycle=$lifecycle,")
        append("paths=$paths,")
        append("report=$report,")
        append("resourceArn=$resourceArn,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("tags=$tags,")
        append("taskId=$taskId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (paths?.hashCode() ?: 0)
        result = 31 * result + (report?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataRepositoryTask

        if (creationTime != other.creationTime) return false
        if (endTime != other.endTime) return false
        if (failureDetails != other.failureDetails) return false
        if (fileSystemId != other.fileSystemId) return false
        if (lifecycle != other.lifecycle) return false
        if (paths != other.paths) return false
        if (report != other.report) return false
        if (resourceArn != other.resourceArn) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (taskId != other.taskId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DataRepositoryTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that Amazon FSx completed processing the task, populated after the task is complete.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Failure message describing why the task failed, it is populated only when `Lifecycle` is set to `FAILED`.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The lifecycle status of the data repository task, as follows:
         * + `PENDING` - Amazon FSx has not started the task.
         * + `EXECUTING` - Amazon FSx is processing the task.
         * + `FAILED` - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The DataRepositoryTaskFailureDetails property provides more information about task failures.
         * + `SUCCEEDED` - FSx completed the task successfully.
         * + `CANCELED` - Amazon FSx canceled the task and it did not complete.
         * + `CANCELING` - FSx is in process of canceling the task.
         *
         * You cannot delete an FSx for Lustre file system if there are data repository tasks for the file system in the `PENDING` or `EXECUTING` states. Please retry when the data repository task is finished (with a status of `CANCELED`, `SUCCEEDED`, or `FAILED`). You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskLifecycle? = null
        /**
         * An array of paths on the Amazon FSx for Lustre file system that specify the data for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.
         *
         * (Default) If `Paths` is not specified, Amazon FSx uses the file system root directory.
         */
        public var paths: List<String>? = null
        /**
         * Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report `Scope` parameter. FSx delivers the report to the file system's linked data repository in Amazon S3, using the path specified in the report `Path` parameter. You can specify whether or not a report gets generated for a task using the `Enabled` parameter.
         */
        public var report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The time that Amazon FSx began processing the task.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the status of the number of files that the task has processed successfully and failed to process.
         */
        public var status: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * The system-generated, unique 17-digit ID of the data repository task.
         */
        public var taskId: kotlin.String? = null
        /**
         * The type of data repository task.
         * + The `EXPORT_TO_REPOSITORY` data repository task exports from your Lustre file system from to a linked S3 bucket.
         * + The `IMPORT_METADATA_FROM_REPOSITORY` data repository task imports metadata changes from a linked S3 bucket to your Lustre file system.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DataRepositoryTask) : this() {
            this.creationTime = x.creationTime
            this.endTime = x.endTime
            this.failureDetails = x.failureDetails
            this.fileSystemId = x.fileSystemId
            this.lifecycle = x.lifecycle
            this.paths = x.paths
            this.report = x.report
            this.resourceArn = x.resourceArn
            this.startTime = x.startTime
            this.status = x.status
            this.tags = x.tags
            this.taskId = x.taskId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DataRepositoryTask = DataRepositoryTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CompletionReport] inside the given [block]
         */
        public fun report(block: aws.sdk.kotlin.services.fsx.model.CompletionReport.Builder.() -> kotlin.Unit) {
            this.report = aws.sdk.kotlin.services.fsx.model.CompletionReport.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskStatus.invoke(block)
        }
    }
}
