// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration object for the Amazon FSx for Lustre file system being deleted in the `DeleteFileSystem` operation.
 */
public class DeleteFileSystemLustreConfiguration private constructor(builder: Builder) {
    /**
     * Use if `SkipFinalBackup` is set to `false`, and you want to apply an array of tags to the final backup. If you have set the file system property `CopyTagsToBackups` to true, and you specify one or more `FinalBackupTags` when deleting a file system, Amazon FSx will not copy any existing file system tags to the backup.
     */
    public val finalBackupTags: List<Tag>? = builder.finalBackupTags
    /**
     * Set `SkipFinalBackup` to false if you want to take a final backup of the file system you are deleting. By default, Amazon FSx will not take a final backup on your behalf when the `DeleteFileSystem` operation is invoked. (Default = true)
     *
     * The `fsx:CreateBackup` permission is required if you set `SkipFinalBackup` to `false` in order to delete the file system and take a final backup.
     */
    public val skipFinalBackup: kotlin.Boolean? = builder.skipFinalBackup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteFileSystemLustreConfiguration(")
        append("finalBackupTags=$finalBackupTags,")
        append("skipFinalBackup=$skipFinalBackup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = finalBackupTags?.hashCode() ?: 0
        result = 31 * result + (skipFinalBackup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteFileSystemLustreConfiguration

        if (finalBackupTags != other.finalBackupTags) return false
        if (skipFinalBackup != other.skipFinalBackup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use if `SkipFinalBackup` is set to `false`, and you want to apply an array of tags to the final backup. If you have set the file system property `CopyTagsToBackups` to true, and you specify one or more `FinalBackupTags` when deleting a file system, Amazon FSx will not copy any existing file system tags to the backup.
         */
        public var finalBackupTags: List<Tag>? = null
        /**
         * Set `SkipFinalBackup` to false if you want to take a final backup of the file system you are deleting. By default, Amazon FSx will not take a final backup on your behalf when the `DeleteFileSystem` operation is invoked. (Default = true)
         *
         * The `fsx:CreateBackup` permission is required if you set `SkipFinalBackup` to `false` in order to delete the file system and take a final backup.
         */
        public var skipFinalBackup: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration) : this() {
            this.finalBackupTags = x.finalBackupTags
            this.skipFinalBackup = x.skipFinalBackup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreConfiguration = DeleteFileSystemLustreConfiguration(this)
    }
}
