// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The response object for the `DeleteFileSystem` operation.
 */
public class DeleteFileSystemResponse private constructor(builder: Builder) {
    /**
     * The ID of the file system that's being deleted.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The file system lifecycle for the deletion request. If the `DeleteFileSystem` operation is successful, this status is `DELETING`.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.FileSystemLifecycle? = builder.lifecycle
    /**
     * The response object for the Amazon FSx for Lustre file system being deleted in the `DeleteFileSystem` operation.
     */
    public val lustreResponse: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreResponse? = builder.lustreResponse
    /**
     * The response object for the OpenZFS file system that's being deleted in the `DeleteFileSystem` operation.
     */
    public val openZfsResponse: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsResponse? = builder.openZfsResponse
    /**
     * The response object for the Microsoft Windows file system used in the `DeleteFileSystem` operation.
     */
    public val windowsResponse: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsResponse? = builder.windowsResponse

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteFileSystemResponse(")
        append("fileSystemId=$fileSystemId,")
        append("lifecycle=$lifecycle,")
        append("lustreResponse=$lustreResponse,")
        append("openZfsResponse=$openZfsResponse,")
        append("windowsResponse=$windowsResponse)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (lustreResponse?.hashCode() ?: 0)
        result = 31 * result + (openZfsResponse?.hashCode() ?: 0)
        result = 31 * result + (windowsResponse?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteFileSystemResponse

        if (fileSystemId != other.fileSystemId) return false
        if (lifecycle != other.lifecycle) return false
        if (lustreResponse != other.lustreResponse) return false
        if (openZfsResponse != other.openZfsResponse) return false
        if (windowsResponse != other.windowsResponse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the file system that's being deleted.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The file system lifecycle for the deletion request. If the `DeleteFileSystem` operation is successful, this status is `DELETING`.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.FileSystemLifecycle? = null
        /**
         * The response object for the Amazon FSx for Lustre file system being deleted in the `DeleteFileSystem` operation.
         */
        public var lustreResponse: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreResponse? = null
        /**
         * The response object for the OpenZFS file system that's being deleted in the `DeleteFileSystem` operation.
         */
        public var openZfsResponse: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsResponse? = null
        /**
         * The response object for the Microsoft Windows file system used in the `DeleteFileSystem` operation.
         */
        public var windowsResponse: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse) : this() {
            this.fileSystemId = x.fileSystemId
            this.lifecycle = x.lifecycle
            this.lustreResponse = x.lustreResponse
            this.openZfsResponse = x.openZfsResponse
            this.windowsResponse = x.windowsResponse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse = DeleteFileSystemResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreResponse] inside the given [block]
         */
        public fun lustreResponse(block: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreResponse.Builder.() -> kotlin.Unit) {
            this.lustreResponse = aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsResponse] inside the given [block]
         */
        public fun openZfsResponse(block: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsResponse.Builder.() -> kotlin.Unit) {
            this.openZfsResponse = aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsResponse] inside the given [block]
         */
        public fun windowsResponse(block: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsResponse.Builder.() -> kotlin.Unit) {
            this.windowsResponse = aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsResponse.invoke(block)
        }
    }
}
