// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS file system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how the amount was provisioned (by the customer or by the system).
 */
public class DiskIopsConfiguration private constructor(builder: Builder) {
    /**
     * The total number of SSD IOPS provisioned for the file system.
     */
    public val iops: kotlin.Long? = builder.iops
    /**
     * Specifies whether the number of IOPS for the file system is using the system default (`AUTOMATIC`) or was provisioned by the customer (`USER_PROVISIONED`).
     */
    public val mode: aws.sdk.kotlin.services.fsx.model.DiskIopsConfigurationMode? = builder.mode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DiskIopsConfiguration(")
        append("iops=$iops,")
        append("mode=$mode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = iops?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DiskIopsConfiguration

        if (iops != other.iops) return false
        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of SSD IOPS provisioned for the file system.
         */
        public var iops: kotlin.Long? = null
        /**
         * Specifies whether the number of IOPS for the file system is using the system default (`AUTOMATIC`) or was provisioned by the customer (`USER_PROVISIONED`).
         */
        public var mode: aws.sdk.kotlin.services.fsx.model.DiskIopsConfigurationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration) : this() {
            this.iops = x.iops
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration = DiskIopsConfiguration(this)
    }
}
