// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A description of a specific Amazon FSx file system.
 */
public class FileSystem private constructor(builder: Builder) {
    /**
     * A list of administrative actions for the file system that are in process or waiting to be processed. Administrative actions describe changes to the Amazon FSx system that you have initiated using the `UpdateFileSystem` operation.
     */
    public val administrativeActions: List<AdministrativeAction>? = builder.administrativeActions
    /**
     * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Domain Name System (DNS) name for the file system.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * A structure providing details of any failures that occurred when creating a file system.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.FileSystemFailureDetails? = builder.failureDetails
    /**
     * The system-generated, unique 17-digit ID of the file system.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The type of Amazon FSx file system, which can be `LUSTRE`, `WINDOWS`, `ONTAP`, or `OPENZFS`.
     */
    public val fileSystemType: aws.sdk.kotlin.services.fsx.model.FileSystemType? = builder.fileSystemType
    /**
     * The Lustre version of the Amazon FSx for Lustre file system, either `2.10` or `2.12`.
     */
    public val fileSystemTypeVersion: kotlin.String? = builder.fileSystemTypeVersion
    /**
     * The ID of the Key Management Service (KMS) key used to encrypt Amazon FSx file system data. Used as follows with Amazon FSx file system types:
     * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The lifecycle status of the file system. The following are the possible values and what they mean:
     * + `AVAILABLE` - The file system is in a healthy state, and is reachable and available for use.
     * + `CREATING` - Amazon FSx is creating the new file system.
     * + `DELETING` - Amazon FSx is deleting an existing file system.
     * + `FAILED` - An existing file system has experienced an unrecoverable failure. When creating a new file system, Amazon FSx was unable to create the file system.
     * + `MISCONFIGURED` - The file system is in a failed but recoverable state.
     * + `MISCONFIGURED_UNAVAILABLE` - (Amazon FSx for Windows File Server only) The file system is currently unavailable due to a change in your Active Directory configuration.
     * + `UPDATING` - The file system is undergoing a customer-initiated update.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.FileSystemLifecycle? = builder.lifecycle
    /**
     * The configuration for the Amazon FSx for Lustre file system.
     */
    public val lustreConfiguration: aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration? = builder.lustreConfiguration
    /**
     * The IDs of the elastic network interfaces from which a specific file system is accessible. The elastic network interface is automatically created in the same virtual private cloud (VPC) that the Amazon FSx file system was created in. For more information, see [Elastic Network Interfaces](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the *Amazon EC2 User Guide.*
     *
     * For an Amazon FSx for Windows File Server file system, you can have one network interface ID. For an Amazon FSx for Lustre file system, you can have more than one.
     */
    public val networkInterfaceIds: List<String>? = builder.networkInterfaceIds
    /**
     * The configuration for this Amazon FSx for NetApp ONTAP file system.
     */
    public val ontapConfiguration: aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration? = builder.ontapConfiguration
    /**
     * The configuration for this Amazon FSx for OpenZFS file system.
     */
    public val openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration? = builder.openZfsConfiguration
    /**
     * The Amazon Web Services account that created the file system. If the file system was created by an Identity and Access Management (IAM) user, the Amazon Web Services account to which the IAM user belongs is the owner.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The Amazon Resource Name (ARN) of the file system resource.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The storage capacity of the file system in gibibytes (GiB).
     */
    public val storageCapacity: kotlin.Int? = builder.storageCapacity
    /**
     * The type of storage the file system is using. If set to `SSD`, the file system uses solid state drive storage. If set to `HDD`, the file system uses hard disk drive storage.
     */
    public val storageType: aws.sdk.kotlin.services.fsx.model.StorageType? = builder.storageType
    /**
     * Specifies the IDs of the subnets that the file system is accessible from. For the Amazon FSx Windows and ONTAP `MULTI_AZ_1` file system deployment type, there are two subnet IDs, one for the preferred file server and one for the standby file server. The preferred file server subnet identified in the `PreferredSubnetID` property. All other file systems have only one subnet ID.
     *
     * For FSx for Lustre file systems, and Single-AZ Windows file systems, this is the ID of the subnet that contains the file system's endpoint. For `MULTI_AZ_1` Windows and ONTAP file systems, the file system endpoint is available in the `PreferredSubnetID`.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags to associate with the file system. For more information, see [Tagging your Amazon EC2 resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html) in the *Amazon EC2 User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the primary virtual private cloud (VPC) for the file system.
     */
    public val vpcId: kotlin.String? = builder.vpcId
    /**
     * The configuration for this Amazon FSx for Windows File Server file system.
     */
    public val windowsConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration? = builder.windowsConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.FileSystem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSystem(")
        append("administrativeActions=$administrativeActions,")
        append("creationTime=$creationTime,")
        append("dnsName=$dnsName,")
        append("failureDetails=$failureDetails,")
        append("fileSystemId=$fileSystemId,")
        append("fileSystemType=$fileSystemType,")
        append("fileSystemTypeVersion=$fileSystemTypeVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("lifecycle=$lifecycle,")
        append("lustreConfiguration=$lustreConfiguration,")
        append("networkInterfaceIds=$networkInterfaceIds,")
        append("ontapConfiguration=$ontapConfiguration,")
        append("openZfsConfiguration=$openZfsConfiguration,")
        append("ownerId=$ownerId,")
        append("resourceArn=$resourceArn,")
        append("storageCapacity=$storageCapacity,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcId=$vpcId,")
        append("windowsConfiguration=$windowsConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = administrativeActions?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (fileSystemType?.hashCode() ?: 0)
        result = 31 * result + (fileSystemTypeVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (lustreConfiguration?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceIds?.hashCode() ?: 0)
        result = 31 * result + (ontapConfiguration?.hashCode() ?: 0)
        result = 31 * result + (openZfsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (storageCapacity ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (windowsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSystem

        if (administrativeActions != other.administrativeActions) return false
        if (creationTime != other.creationTime) return false
        if (dnsName != other.dnsName) return false
        if (failureDetails != other.failureDetails) return false
        if (fileSystemId != other.fileSystemId) return false
        if (fileSystemType != other.fileSystemType) return false
        if (fileSystemTypeVersion != other.fileSystemTypeVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lifecycle != other.lifecycle) return false
        if (lustreConfiguration != other.lustreConfiguration) return false
        if (networkInterfaceIds != other.networkInterfaceIds) return false
        if (ontapConfiguration != other.ontapConfiguration) return false
        if (openZfsConfiguration != other.openZfsConfiguration) return false
        if (ownerId != other.ownerId) return false
        if (resourceArn != other.resourceArn) return false
        if (storageCapacity != other.storageCapacity) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false
        if (windowsConfiguration != other.windowsConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.FileSystem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of administrative actions for the file system that are in process or waiting to be processed. Administrative actions describe changes to the Amazon FSx system that you have initiated using the `UpdateFileSystem` operation.
         */
        public var administrativeActions: List<AdministrativeAction>? = null
        /**
         * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Domain Name System (DNS) name for the file system.
         */
        public var dnsName: kotlin.String? = null
        /**
         * A structure providing details of any failures that occurred when creating a file system.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.FileSystemFailureDetails? = null
        /**
         * The system-generated, unique 17-digit ID of the file system.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The type of Amazon FSx file system, which can be `LUSTRE`, `WINDOWS`, `ONTAP`, or `OPENZFS`.
         */
        public var fileSystemType: aws.sdk.kotlin.services.fsx.model.FileSystemType? = null
        /**
         * The Lustre version of the Amazon FSx for Lustre file system, either `2.10` or `2.12`.
         */
        public var fileSystemTypeVersion: kotlin.String? = null
        /**
         * The ID of the Key Management Service (KMS) key used to encrypt Amazon FSx file system data. Used as follows with Amazon FSx file system types:
         * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
         * + Amazon FSx for NetApp ONTAP
         * + Amazon FSx for OpenZFS
         * + Amazon FSx for Windows File Server
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The lifecycle status of the file system. The following are the possible values and what they mean:
         * + `AVAILABLE` - The file system is in a healthy state, and is reachable and available for use.
         * + `CREATING` - Amazon FSx is creating the new file system.
         * + `DELETING` - Amazon FSx is deleting an existing file system.
         * + `FAILED` - An existing file system has experienced an unrecoverable failure. When creating a new file system, Amazon FSx was unable to create the file system.
         * + `MISCONFIGURED` - The file system is in a failed but recoverable state.
         * + `MISCONFIGURED_UNAVAILABLE` - (Amazon FSx for Windows File Server only) The file system is currently unavailable due to a change in your Active Directory configuration.
         * + `UPDATING` - The file system is undergoing a customer-initiated update.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.FileSystemLifecycle? = null
        /**
         * The configuration for the Amazon FSx for Lustre file system.
         */
        public var lustreConfiguration: aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration? = null
        /**
         * The IDs of the elastic network interfaces from which a specific file system is accessible. The elastic network interface is automatically created in the same virtual private cloud (VPC) that the Amazon FSx file system was created in. For more information, see [Elastic Network Interfaces](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the *Amazon EC2 User Guide.*
         *
         * For an Amazon FSx for Windows File Server file system, you can have one network interface ID. For an Amazon FSx for Lustre file system, you can have more than one.
         */
        public var networkInterfaceIds: List<String>? = null
        /**
         * The configuration for this Amazon FSx for NetApp ONTAP file system.
         */
        public var ontapConfiguration: aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration? = null
        /**
         * The configuration for this Amazon FSx for OpenZFS file system.
         */
        public var openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration? = null
        /**
         * The Amazon Web Services account that created the file system. If the file system was created by an Identity and Access Management (IAM) user, the Amazon Web Services account to which the IAM user belongs is the owner.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the file system resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The storage capacity of the file system in gibibytes (GiB).
         */
        public var storageCapacity: kotlin.Int? = null
        /**
         * The type of storage the file system is using. If set to `SSD`, the file system uses solid state drive storage. If set to `HDD`, the file system uses hard disk drive storage.
         */
        public var storageType: aws.sdk.kotlin.services.fsx.model.StorageType? = null
        /**
         * Specifies the IDs of the subnets that the file system is accessible from. For the Amazon FSx Windows and ONTAP `MULTI_AZ_1` file system deployment type, there are two subnet IDs, one for the preferred file server and one for the standby file server. The preferred file server subnet identified in the `PreferredSubnetID` property. All other file systems have only one subnet ID.
         *
         * For FSx for Lustre file systems, and Single-AZ Windows file systems, this is the ID of the subnet that contains the file system's endpoint. For `MULTI_AZ_1` Windows and ONTAP file systems, the file system endpoint is available in the `PreferredSubnetID`.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags to associate with the file system. For more information, see [Tagging your Amazon EC2 resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html) in the *Amazon EC2 User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the primary virtual private cloud (VPC) for the file system.
         */
        public var vpcId: kotlin.String? = null
        /**
         * The configuration for this Amazon FSx for Windows File Server file system.
         */
        public var windowsConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.FileSystem) : this() {
            this.administrativeActions = x.administrativeActions
            this.creationTime = x.creationTime
            this.dnsName = x.dnsName
            this.failureDetails = x.failureDetails
            this.fileSystemId = x.fileSystemId
            this.fileSystemType = x.fileSystemType
            this.fileSystemTypeVersion = x.fileSystemTypeVersion
            this.kmsKeyId = x.kmsKeyId
            this.lifecycle = x.lifecycle
            this.lustreConfiguration = x.lustreConfiguration
            this.networkInterfaceIds = x.networkInterfaceIds
            this.ontapConfiguration = x.ontapConfiguration
            this.openZfsConfiguration = x.openZfsConfiguration
            this.ownerId = x.ownerId
            this.resourceArn = x.resourceArn
            this.storageCapacity = x.storageCapacity
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcId = x.vpcId
            this.windowsConfiguration = x.windowsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.FileSystem = FileSystem(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileSystemFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.FileSystemFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.FileSystemFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration] inside the given [block]
         */
        public fun lustreConfiguration(block: aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration.Builder.() -> kotlin.Unit) {
            this.lustreConfiguration = aws.sdk.kotlin.services.fsx.model.LustreFileSystemConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration] inside the given [block]
         */
        public fun ontapConfiguration(block: aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration.Builder.() -> kotlin.Unit) {
            this.ontapConfiguration = aws.sdk.kotlin.services.fsx.model.OntapFileSystemConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration] inside the given [block]
         */
        public fun openZfsConfiguration(block: aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration.Builder.() -> kotlin.Unit) {
            this.openZfsConfiguration = aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration] inside the given [block]
         */
        public fun windowsConfiguration(block: aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration.Builder.() -> kotlin.Unit) {
            this.windowsConfiguration = aws.sdk.kotlin.services.fsx.model.WindowsFileSystemConfiguration.invoke(block)
        }
    }
}
