// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration for Lustre logging used to write the enabled logging events for your file system to Amazon CloudWatch Logs.
 *
 * When logging is enabled, Lustre logs error and warning events from data repository operations such as automatic export and data repository tasks. To learn more about Lustre logging, see [Logging with Amazon CloudWatch Logs](https://docs.aws.amazon.com/fsx/latest/LustreGuide/cw-event-logging.html).
 */
public class LustreLogConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that specifies the destination of the logs. The destination can be any Amazon CloudWatch Logs log group ARN. The destination ARN must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The data repository events that are logged by Amazon FSx.
     * + `WARN_ONLY` - only warning events are logged.
     * + `ERROR_ONLY` - only error events are logged.
     * + `WARN_ERROR` - both warning events and error events are logged.
     * + `DISABLED` - logging of data repository events is turned off.
     */
    public val level: aws.sdk.kotlin.services.fsx.model.LustreAccessAuditLogLevel? = builder.level

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LustreLogConfiguration(")
        append("destination=$destination,")
        append("level=$level)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (level?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LustreLogConfiguration

        if (destination != other.destination) return false
        if (level != other.level) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that specifies the destination of the logs. The destination can be any Amazon CloudWatch Logs log group ARN. The destination ARN must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.
         */
        public var destination: kotlin.String? = null
        /**
         * The data repository events that are logged by Amazon FSx.
         * + `WARN_ONLY` - only warning events are logged.
         * + `ERROR_ONLY` - only error events are logged.
         * + `WARN_ERROR` - both warning events and error events are logged.
         * + `DISABLED` - logging of data repository events is turned off.
         */
        public var level: aws.sdk.kotlin.services.fsx.model.LustreAccessAuditLogLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration) : this() {
            this.destination = x.destination
            this.level = x.level
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.LustreLogConfiguration = LustreLogConfiguration(this)
    }
}
