// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The Lustre logging configuration used when creating or updating an Amazon FSx for Lustre file system. Lustre logging writes the enabled logging events for your file system to Amazon CloudWatch Logs.
 *
 * Error and warning events can be logged from the following data repository operations:
 * + Automatic export
 * + Data repository tasks
 *
 * To learn more about Lustre logging, see [Logging to Amazon CloudWatch Logs](https://docs.aws.amazon.com/fsx/latest/LustreGuide/cw-event-logging.html).
 */
public class LustreLogCreateConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that specifies the destination of the logs.
     *
     * The destination can be any Amazon CloudWatch Logs log group ARN, with the following requirements:
     * + The destination ARN that you provide must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.
     * + The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix.
     * + If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
     * + If `Destination` is provided and the resource does not exist, the request will fail with a `BadRequest` error.
     * + If `Level` is set to `DISABLED`, you cannot specify a destination in `Destination`.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * Sets which data repository events are logged by Amazon FSx.
     * + `WARN_ONLY` - only warning events are logged.
     * + `ERROR_ONLY` - only error events are logged.
     * + `WARN_ERROR` - both warning events and error events are logged.
     * + `DISABLED` - logging of data repository events is turned off.
     */
    public val level: aws.sdk.kotlin.services.fsx.model.LustreAccessAuditLogLevel? = builder.level

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LustreLogCreateConfiguration(")
        append("destination=$destination,")
        append("level=$level)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (level?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LustreLogCreateConfiguration

        if (destination != other.destination) return false
        if (level != other.level) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that specifies the destination of the logs.
         *
         * The destination can be any Amazon CloudWatch Logs log group ARN, with the following requirements:
         * + The destination ARN that you provide must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.
         * + The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix.
         * + If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
         * + If `Destination` is provided and the resource does not exist, the request will fail with a `BadRequest` error.
         * + If `Level` is set to `DISABLED`, you cannot specify a destination in `Destination`.
         */
        public var destination: kotlin.String? = null
        /**
         * Sets which data repository events are logged by Amazon FSx.
         * + `WARN_ONLY` - only warning events are logged.
         * + `ERROR_ONLY` - only error events are logged.
         * + `WARN_ERROR` - both warning events and error events are logged.
         * + `DISABLED` - logging of data repository events is turned off.
         */
        public var level: aws.sdk.kotlin.services.fsx.model.LustreAccessAuditLogLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration) : this() {
            this.destination = x.destination
            this.level = x.level
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.LustreLogCreateConfiguration = LustreLogCreateConfiguration(this)
    }
}
