// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration for Lustre root squash used to restrict root-level access from clients that try to access your FSx for Lustre file system as root. Use the `RootSquash` parameter to enable root squash. To learn more about Lustre root squash, see [Lustre root squash](https://docs.aws.amazon.com/fsx/latest/LustreGuide/root-squash.html).
 *
 * You can also use the `NoSquashNids` parameter to provide an array of clients who are not affected by the root squash setting. These clients will access the file system as root, with unrestricted privileges.
 */
public class LustreRootSquashConfiguration private constructor(builder: Builder) {
    /**
     * When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses:
     * + A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, `10.0.1.6@tcp`).
     * + An address range is described using a dash to separate the range (for example, `10.0.[2-10].[1-255]@tcp`).
     */
    public val noSquashNids: List<String>? = builder.noSquashNids
    /**
     * You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format `UID:GID` (for example, `365534:65534`). The UID and GID values can range from `0` to `4294967294`:
     * + A non-zero value for UID and GID enables root squash. The UID and GID values can be different, but each must be a non-zero value.
     * + A value of `0` (zero) for UID and GID indicates root, and therefore disables root squash.
     *
     * When root squash is enabled, the user ID and group ID of a root user accessing the file system are re-mapped to the UID and GID you provide.
     */
    public val rootSquash: kotlin.String? = builder.rootSquash

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LustreRootSquashConfiguration(")
        append("noSquashNids=$noSquashNids,")
        append("rootSquash=$rootSquash)")
    }

    override fun hashCode(): kotlin.Int {
        var result = noSquashNids?.hashCode() ?: 0
        result = 31 * result + (rootSquash?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LustreRootSquashConfiguration

        if (noSquashNids != other.noSquashNids) return false
        if (rootSquash != other.rootSquash) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses:
         * + A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, `10.0.1.6@tcp`).
         * + An address range is described using a dash to separate the range (for example, `10.0.[2-10].[1-255]@tcp`).
         */
        public var noSquashNids: List<String>? = null
        /**
         * You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format `UID:GID` (for example, `365534:65534`). The UID and GID values can range from `0` to `4294967294`:
         * + A non-zero value for UID and GID enables root squash. The UID and GID values can be different, but each must be a non-zero value.
         * + A value of `0` (zero) for UID and GID indicates root, and therefore disables root squash.
         *
         * When root squash is enabled, the user ID and group ID of a root user accessing the file system are re-mapped to the UID and GID you provide.
         */
        public var rootSquash: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration) : this() {
            this.noSquashNids = x.noSquashNids
            this.rootSquash = x.rootSquash
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.LustreRootSquashConfiguration = LustreRootSquashConfiguration(this)
    }
}
