// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration of an Amazon FSx for NetApp ONTAP volume.
 */
public class OntapVolumeConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
     * + `NONE` specifies that the volume doesn't have a FlexCache configuration. `NONE` is the default.
     * + `ORIGIN` specifies that the volume is the origin volume for a FlexCache volume.
     * + `CACHE` specifies that the volume is a FlexCache volume.
     */
    public val flexCacheEndpointType: aws.sdk.kotlin.services.fsx.model.FlexCacheEndpointType? = builder.flexCacheEndpointType
    /**
     * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a `JunctionPath` directly below a parent volume junction or on a directory within a volume. A `JunctionPath` for a volume named `vol3` might be `/vol1/vol2/vol3`, or `/vol1/dir2/vol3`, or even `/dir1/dir2/vol3`.
     */
    public val junctionPath: kotlin.String? = builder.junctionPath
    /**
     * Specifies the type of volume. Valid values are the following:
     * + `RW` specifies a read/write volume. `RW` is the default.
     * + `DP` specifies a data-protection volume. You can protect data by replicating it to data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
     * + `LS` specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a FlexVol volume by providing additional read-only access to clients.
     */
    public val ontapVolumeType: aws.sdk.kotlin.services.fsx.model.OntapVolumeType? = builder.ontapVolumeType
    /**
     * The security style for the volume, which can be `UNIX`, `NTFS`, or `MIXED`.
     */
    public val securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = builder.securityStyle
    /**
     * The configured size of the volume, in megabytes (MBs).
     */
    public val sizeInMegabytes: kotlin.Int? = builder.sizeInMegabytes
    /**
     * The volume's storage efficiency setting.
     */
    public val storageEfficiencyEnabled: kotlin.Boolean? = builder.storageEfficiencyEnabled
    /**
     * The ID of the volume's storage virtual machine.
     */
    public val storageVirtualMachineId: kotlin.String? = builder.storageVirtualMachineId
    /**
     * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only one volume on an SVM can be the root volume. This value defaults to `false`. If this value is `true`, then this is the SVM root volume.
     *
     * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This flag, when set to `false`, helps you identify which volumes to delete before you can delete the SVM.
     */
    public val storageVirtualMachineRoot: kotlin.Boolean? = builder.storageVirtualMachineRoot
    /**
     * The volume's `TieringPolicy` setting.
     */
    public val tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = builder.tieringPolicy
    /**
     * The volume's universally unique identifier (UUID).
     */
    public val uuid: kotlin.String? = builder.uuid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OntapVolumeConfiguration(")
        append("flexCacheEndpointType=$flexCacheEndpointType,")
        append("junctionPath=$junctionPath,")
        append("ontapVolumeType=$ontapVolumeType,")
        append("securityStyle=$securityStyle,")
        append("sizeInMegabytes=$sizeInMegabytes,")
        append("storageEfficiencyEnabled=$storageEfficiencyEnabled,")
        append("storageVirtualMachineId=$storageVirtualMachineId,")
        append("storageVirtualMachineRoot=$storageVirtualMachineRoot,")
        append("tieringPolicy=$tieringPolicy,")
        append("uuid=$uuid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = flexCacheEndpointType?.hashCode() ?: 0
        result = 31 * result + (junctionPath?.hashCode() ?: 0)
        result = 31 * result + (ontapVolumeType?.hashCode() ?: 0)
        result = 31 * result + (securityStyle?.hashCode() ?: 0)
        result = 31 * result + (sizeInMegabytes ?: 0)
        result = 31 * result + (storageEfficiencyEnabled?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineId?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineRoot?.hashCode() ?: 0)
        result = 31 * result + (tieringPolicy?.hashCode() ?: 0)
        result = 31 * result + (uuid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OntapVolumeConfiguration

        if (flexCacheEndpointType != other.flexCacheEndpointType) return false
        if (junctionPath != other.junctionPath) return false
        if (ontapVolumeType != other.ontapVolumeType) return false
        if (securityStyle != other.securityStyle) return false
        if (sizeInMegabytes != other.sizeInMegabytes) return false
        if (storageEfficiencyEnabled != other.storageEfficiencyEnabled) return false
        if (storageVirtualMachineId != other.storageVirtualMachineId) return false
        if (storageVirtualMachineRoot != other.storageVirtualMachineRoot) return false
        if (tieringPolicy != other.tieringPolicy) return false
        if (uuid != other.uuid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
         * + `NONE` specifies that the volume doesn't have a FlexCache configuration. `NONE` is the default.
         * + `ORIGIN` specifies that the volume is the origin volume for a FlexCache volume.
         * + `CACHE` specifies that the volume is a FlexCache volume.
         */
        public var flexCacheEndpointType: aws.sdk.kotlin.services.fsx.model.FlexCacheEndpointType? = null
        /**
         * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a `JunctionPath` directly below a parent volume junction or on a directory within a volume. A `JunctionPath` for a volume named `vol3` might be `/vol1/vol2/vol3`, or `/vol1/dir2/vol3`, or even `/dir1/dir2/vol3`.
         */
        public var junctionPath: kotlin.String? = null
        /**
         * Specifies the type of volume. Valid values are the following:
         * + `RW` specifies a read/write volume. `RW` is the default.
         * + `DP` specifies a data-protection volume. You can protect data by replicating it to data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
         * + `LS` specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a FlexVol volume by providing additional read-only access to clients.
         */
        public var ontapVolumeType: aws.sdk.kotlin.services.fsx.model.OntapVolumeType? = null
        /**
         * The security style for the volume, which can be `UNIX`, `NTFS`, or `MIXED`.
         */
        public var securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = null
        /**
         * The configured size of the volume, in megabytes (MBs).
         */
        public var sizeInMegabytes: kotlin.Int? = null
        /**
         * The volume's storage efficiency setting.
         */
        public var storageEfficiencyEnabled: kotlin.Boolean? = null
        /**
         * The ID of the volume's storage virtual machine.
         */
        public var storageVirtualMachineId: kotlin.String? = null
        /**
         * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only one volume on an SVM can be the root volume. This value defaults to `false`. If this value is `true`, then this is the SVM root volume.
         *
         * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This flag, when set to `false`, helps you identify which volumes to delete before you can delete the SVM.
         */
        public var storageVirtualMachineRoot: kotlin.Boolean? = null
        /**
         * The volume's `TieringPolicy` setting.
         */
        public var tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = null
        /**
         * The volume's universally unique identifier (UUID).
         */
        public var uuid: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration) : this() {
            this.flexCacheEndpointType = x.flexCacheEndpointType
            this.junctionPath = x.junctionPath
            this.ontapVolumeType = x.ontapVolumeType
            this.securityStyle = x.securityStyle
            this.sizeInMegabytes = x.sizeInMegabytes
            this.storageEfficiencyEnabled = x.storageEfficiencyEnabled
            this.storageVirtualMachineId = x.storageVirtualMachineId
            this.storageVirtualMachineRoot = x.storageVirtualMachineRoot
            this.tieringPolicy = x.tieringPolicy
            this.uuid = x.uuid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration = OntapVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.TieringPolicy] inside the given [block]
         */
        public fun tieringPolicy(block: aws.sdk.kotlin.services.fsx.model.TieringPolicy.Builder.() -> kotlin.Unit) {
            this.tieringPolicy = aws.sdk.kotlin.services.fsx.model.TieringPolicy.invoke(block)
        }
    }
}
