// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * Specifies who can mount an OpenZFS file system and the options available while mounting the file system.
 */
public class OpenZfsClientConfiguration private constructor(builder: Builder) {
    /**
     * A value that specifies who can mount the file system. You can provide a wildcard character (`*`), an IP address (`0.0.0.0`), or a CIDR address (`192.0.2.0/24`). By default, Amazon FSx uses the wildcard character when specifying the client.
     */
    public val clients: kotlin.String? = builder.clients
    /**
     * The options to use when mounting the file system. For a list of options that you can use with Network File System (NFS), see the [exports(5) - Linux man page](https://linux.die.net/man/5/exports). When choosing your options, consider the following:
     * + `crossmnt` is used by default. If you don't specify `crossmnt` when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.
     * + `sync` is used by default. If you instead specify `async`, the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.
     */
    public val options: List<String>? = builder.options

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OpenZfsClientConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenZfsClientConfiguration(")
        append("clients=$clients,")
        append("options=$options)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clients?.hashCode() ?: 0
        result = 31 * result + (options?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenZfsClientConfiguration

        if (clients != other.clients) return false
        if (options != other.options) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OpenZfsClientConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value that specifies who can mount the file system. You can provide a wildcard character (`*`), an IP address (`0.0.0.0`), or a CIDR address (`192.0.2.0/24`). By default, Amazon FSx uses the wildcard character when specifying the client.
         */
        public var clients: kotlin.String? = null
        /**
         * The options to use when mounting the file system. For a list of options that you can use with Network File System (NFS), see the [exports(5) - Linux man page](https://linux.die.net/man/5/exports). When choosing your options, consider the following:
         * + `crossmnt` is used by default. If you don't specify `crossmnt` when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.
         * + `sync` is used by default. If you instead specify `async`, the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.
         */
        public var options: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OpenZfsClientConfiguration) : this() {
            this.clients = x.clients
            this.options = x.options
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OpenZfsClientConfiguration = OpenZfsClientConfiguration(this)
    }
}
