// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration of an Amazon FSx for OpenZFS root volume.
 */
public class OpenZfsCreateRootVolumeConfiguration private constructor(builder: Builder) {
    /**
     * A Boolean value indicating whether tags for the volume should be copied to snapshots of the volume. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
     */
    public val copyTagsToSnapshots: kotlin.Boolean? = builder.copyTagsToSnapshots
    /**
     * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
     * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
     * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
     * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
     */
    public val dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = builder.dataCompressionType
    /**
     * The configuration object for mounting a file system.
     */
    public val nfsExports: List<OpenZfsNfsExport>? = builder.nfsExports
    /**
     * A Boolean value indicating whether the volume is read-only. Setting this value to `true` can be useful after you have completed changes to a volume and no longer want changes to occur.
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on setting a custom record size, see [ Tips for maximizing performance](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs) in the *Amazon FSx for OpenZFS User Guide*.
     */
    public val recordSizeKib: kotlin.Int? = builder.recordSizeKib
    /**
     * An object specifying how much storage users or groups can use on the volume.
     */
    public val userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = builder.userAndGroupQuotas

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OpenZfsCreateRootVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenZfsCreateRootVolumeConfiguration(")
        append("copyTagsToSnapshots=$copyTagsToSnapshots,")
        append("dataCompressionType=$dataCompressionType,")
        append("nfsExports=$nfsExports,")
        append("readOnly=$readOnly,")
        append("recordSizeKib=$recordSizeKib,")
        append("userAndGroupQuotas=$userAndGroupQuotas)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTagsToSnapshots?.hashCode() ?: 0
        result = 31 * result + (dataCompressionType?.hashCode() ?: 0)
        result = 31 * result + (nfsExports?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (recordSizeKib ?: 0)
        result = 31 * result + (userAndGroupQuotas?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenZfsCreateRootVolumeConfiguration

        if (copyTagsToSnapshots != other.copyTagsToSnapshots) return false
        if (dataCompressionType != other.dataCompressionType) return false
        if (nfsExports != other.nfsExports) return false
        if (readOnly != other.readOnly) return false
        if (recordSizeKib != other.recordSizeKib) return false
        if (userAndGroupQuotas != other.userAndGroupQuotas) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OpenZfsCreateRootVolumeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A Boolean value indicating whether tags for the volume should be copied to snapshots of the volume. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
         */
        public var copyTagsToSnapshots: kotlin.Boolean? = null
        /**
         * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
         * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
         * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
         * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
         */
        public var dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = null
        /**
         * The configuration object for mounting a file system.
         */
        public var nfsExports: List<OpenZfsNfsExport>? = null
        /**
         * A Boolean value indicating whether the volume is read-only. Setting this value to `true` can be useful after you have completed changes to a volume and no longer want changes to occur.
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on setting a custom record size, see [ Tips for maximizing performance](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs) in the *Amazon FSx for OpenZFS User Guide*.
         */
        public var recordSizeKib: kotlin.Int? = null
        /**
         * An object specifying how much storage users or groups can use on the volume.
         */
        public var userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OpenZfsCreateRootVolumeConfiguration) : this() {
            this.copyTagsToSnapshots = x.copyTagsToSnapshots
            this.dataCompressionType = x.dataCompressionType
            this.nfsExports = x.nfsExports
            this.readOnly = x.readOnly
            this.recordSizeKib = x.recordSizeKib
            this.userAndGroupQuotas = x.userAndGroupQuotas
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OpenZfsCreateRootVolumeConfiguration = OpenZfsCreateRootVolumeConfiguration(this)
    }
}
