// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory. For more information, see [ Using Amazon FSx with your self-managed Microsoft Active Directory](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or [Managing SVMs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
 */
public class SelfManagedActiveDirectoryConfiguration private constructor(builder: Builder) {
    /**
     * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
     */
    public val dnsIps: List<String>? = builder.dnsIps
    /**
     * The fully qualified domain name of the self-managed AD directory, such as `corp.example.com`.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * (Optional) The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, setting audit controls (audit ACLs) on files and folders, and administering the file system remotely by using the FSx Remote PowerShell. The group that you specify must already exist in your domain. If you don't provide one, your AD domain's Domain Admins group is used.
     */
    public val fileSystemAdministratorsGroup: kotlin.String? = builder.fileSystemAdministratorsGroup
    /**
     * (Optional) The fully qualified distinguished name of the organizational unit within your self-managed AD directory. Amazon FSx only accepts OU as the direct parent of the file system. An example is `OU=FSx,DC=yourdomain,DC=corp,DC=com`. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253). If none is provided, the FSx file system is created in the default location of your self-managed AD directory.
     *
     * Only Organizational Unit (OU) objects can be the direct parent of the file system that you're creating.
     */
    public val organizationalUnitDistinguishedName: kotlin.String? = builder.organizationalUnitDistinguishedName
    /**
     * The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
     */
    public val password: kotlin.String? = builder.password
    /**
     * The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain. This account must have the permission to join computers to the domain in the organizational unit provided in `OrganizationalUnitDistinguishedName`, or in the default location of your AD domain.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SelfManagedActiveDirectoryConfiguration(")
        append("dnsIps=$dnsIps,")
        append("domainName=$domainName,")
        append("fileSystemAdministratorsGroup=$fileSystemAdministratorsGroup,")
        append("organizationalUnitDistinguishedName=$organizationalUnitDistinguishedName,")
        append("password=*** Sensitive Data Redacted ***,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsIps?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAdministratorsGroup?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitDistinguishedName?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SelfManagedActiveDirectoryConfiguration

        if (dnsIps != other.dnsIps) return false
        if (domainName != other.domainName) return false
        if (fileSystemAdministratorsGroup != other.fileSystemAdministratorsGroup) return false
        if (organizationalUnitDistinguishedName != other.organizationalUnitDistinguishedName) return false
        if (password != other.password) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
         */
        public var dnsIps: List<String>? = null
        /**
         * The fully qualified domain name of the self-managed AD directory, such as `corp.example.com`.
         */
        public var domainName: kotlin.String? = null
        /**
         * (Optional) The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, setting audit controls (audit ACLs) on files and folders, and administering the file system remotely by using the FSx Remote PowerShell. The group that you specify must already exist in your domain. If you don't provide one, your AD domain's Domain Admins group is used.
         */
        public var fileSystemAdministratorsGroup: kotlin.String? = null
        /**
         * (Optional) The fully qualified distinguished name of the organizational unit within your self-managed AD directory. Amazon FSx only accepts OU as the direct parent of the file system. An example is `OU=FSx,DC=yourdomain,DC=corp,DC=com`. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253). If none is provided, the FSx file system is created in the default location of your self-managed AD directory.
         *
         * Only Organizational Unit (OU) objects can be the direct parent of the file system that you're creating.
         */
        public var organizationalUnitDistinguishedName: kotlin.String? = null
        /**
         * The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
         */
        public var password: kotlin.String? = null
        /**
         * The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain. This account must have the permission to join computers to the domain in the organizational unit provided in `OrganizationalUnitDistinguishedName`, or in the default location of your AD domain.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration) : this() {
            this.dnsIps = x.dnsIps
            this.domainName = x.domainName
            this.fileSystemAdministratorsGroup = x.fileSystemAdministratorsGroup
            this.organizationalUnitDistinguishedName = x.organizationalUnitDistinguishedName
            this.password = x.password
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration = SelfManagedActiveDirectoryConfiguration(this)
    }
}
