// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The configuration that Amazon FSx uses to join the Windows File Server instance to a self-managed Microsoft Active Directory (AD) directory.
 */
public class SelfManagedActiveDirectoryConfigurationUpdates private constructor(builder: Builder) {
    /**
     * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
     */
    public val dnsIps: List<String>? = builder.dnsIps
    /**
     * The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
     */
    public val password: kotlin.String? = builder.password
    /**
     * The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain. This account must have the permission to join computers to the domain in the organizational unit provided in `OrganizationalUnitDistinguishedName`.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SelfManagedActiveDirectoryConfigurationUpdates(")
        append("dnsIps=$dnsIps,")
        append("password=*** Sensitive Data Redacted ***,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsIps?.hashCode() ?: 0
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SelfManagedActiveDirectoryConfigurationUpdates

        if (dnsIps != other.dnsIps) return false
        if (password != other.password) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
         */
        public var dnsIps: List<String>? = null
        /**
         * The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
         */
        public var password: kotlin.String? = null
        /**
         * The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain. This account must have the permission to join computers to the domain in the organizational unit provided in `OrganizationalUnitDistinguishedName`.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates) : this() {
            this.dnsIps = x.dnsIps
            this.password = x.password
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates = SelfManagedActiveDirectoryConfigurationUpdates(this)
    }
}
