// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A snapshot of an Amazon FSx for OpenZFS volume.
 */
public class Snapshot private constructor(builder: Builder) {
    /**
     * A list of administrative actions for the file system that are in process or waiting to be processed. Administrative actions describe changes to the Amazon FSx system.
     */
    public val administrativeActions: List<AdministrativeAction>? = builder.administrativeActions
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The lifecycle status of the snapshot.
     * + `PENDING` - Amazon FSx hasn't started creating the snapshot.
     * + `CREATING` - Amazon FSx is creating the snapshot.
     * + `DELETING` - Amazon FSx is deleting the snapshot.
     * + `AVAILABLE` - The snapshot is fully available.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.SnapshotLifecycle? = builder.lifecycle
    /**
     * Describes why a resource lifecycle state changed.
     */
    public val lifecycleTransitionReason: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason? = builder.lifecycleTransitionReason
    /**
     * The name of the snapshot.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The ID of the snapshot.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the volume that the snapshot is of.
     */
    public val volumeId: kotlin.String? = builder.volumeId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("administrativeActions=$administrativeActions,")
        append("creationTime=$creationTime,")
        append("lifecycle=$lifecycle,")
        append("lifecycleTransitionReason=$lifecycleTransitionReason,")
        append("name=$name,")
        append("resourceArn=$resourceArn,")
        append("snapshotId=$snapshotId,")
        append("tags=$tags,")
        append("volumeId=$volumeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = administrativeActions?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (lifecycleTransitionReason?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (administrativeActions != other.administrativeActions) return false
        if (creationTime != other.creationTime) return false
        if (lifecycle != other.lifecycle) return false
        if (lifecycleTransitionReason != other.lifecycleTransitionReason) return false
        if (name != other.name) return false
        if (resourceArn != other.resourceArn) return false
        if (snapshotId != other.snapshotId) return false
        if (tags != other.tags) return false
        if (volumeId != other.volumeId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.Snapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of administrative actions for the file system that are in process or waiting to be processed. Administrative actions describe changes to the Amazon FSx system.
         */
        public var administrativeActions: List<AdministrativeAction>? = null
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle status of the snapshot.
         * + `PENDING` - Amazon FSx hasn't started creating the snapshot.
         * + `CREATING` - Amazon FSx is creating the snapshot.
         * + `DELETING` - Amazon FSx is deleting the snapshot.
         * + `AVAILABLE` - The snapshot is fully available.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.SnapshotLifecycle? = null
        /**
         * Describes why a resource lifecycle state changed.
         */
        public var lifecycleTransitionReason: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason? = null
        /**
         * The name of the snapshot.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The ID of the snapshot.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the volume that the snapshot is of.
         */
        public var volumeId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.Snapshot) : this() {
            this.administrativeActions = x.administrativeActions
            this.creationTime = x.creationTime
            this.lifecycle = x.lifecycle
            this.lifecycleTransitionReason = x.lifecycleTransitionReason
            this.name = x.name
            this.resourceArn = x.resourceArn
            this.snapshotId = x.snapshotId
            this.tags = x.tags
            this.volumeId = x.volumeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.Snapshot = Snapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason] inside the given [block]
         */
        public fun lifecycleTransitionReason(block: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason.Builder.() -> kotlin.Unit) {
            this.lifecycleTransitionReason = aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason.invoke(block)
        }
    }
}
