// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuration.
 */
public class StorageVirtualMachine private constructor(builder: Builder) {
    /**
     * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
     */
    public val activeDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SvmActiveDirectoryConfiguration? = builder.activeDirectoryConfiguration
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The endpoints that are used to access data or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They are the `Iscsi`, `Management`, `Nfs`, and `Smb` endpoints.
     */
    public val endpoints: aws.sdk.kotlin.services.fsx.model.SvmEndpoints? = builder.endpoints
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * Describes the SVM's lifecycle status.
     * + `CREATED` - The SVM is fully available for use.
     * + `CREATING` - Amazon FSx is creating the new SVM.
     * + `DELETING` - Amazon FSx is deleting an existing SVM.
     * + `FAILED` - Amazon FSx was unable to create the SVM.
     * + `MISCONFIGURED` - The SVM is in a failed but recoverable state.
     * + `PENDING` - Amazon FSx has not started creating the SVM.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.StorageVirtualMachineLifecycle? = builder.lifecycle
    /**
     * Describes why the SVM lifecycle state changed.
     */
    public val lifecycleTransitionReason: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason? = builder.lifecycleTransitionReason
    /**
     * The name of the SVM, if provisioned.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The security style of the root volume of the SVM.
     */
    public val rootVolumeSecurityStyle: aws.sdk.kotlin.services.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle? = builder.rootVolumeSecurityStyle
    /**
     * The SVM's system generated unique ID.
     */
    public val storageVirtualMachineId: kotlin.String? = builder.storageVirtualMachineId
    /**
     * Describes the SVM's subtype.
     */
    public val subtype: aws.sdk.kotlin.services.fsx.model.StorageVirtualMachineSubtype? = builder.subtype
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The SVM's UUID (universally unique identifier).
     */
    public val uuid: kotlin.String? = builder.uuid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.StorageVirtualMachine = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageVirtualMachine(")
        append("activeDirectoryConfiguration=$activeDirectoryConfiguration,")
        append("creationTime=$creationTime,")
        append("endpoints=$endpoints,")
        append("fileSystemId=$fileSystemId,")
        append("lifecycle=$lifecycle,")
        append("lifecycleTransitionReason=$lifecycleTransitionReason,")
        append("name=$name,")
        append("resourceArn=$resourceArn,")
        append("rootVolumeSecurityStyle=$rootVolumeSecurityStyle,")
        append("storageVirtualMachineId=$storageVirtualMachineId,")
        append("subtype=$subtype,")
        append("tags=$tags,")
        append("uuid=$uuid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryConfiguration?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (lifecycleTransitionReason?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (rootVolumeSecurityStyle?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineId?.hashCode() ?: 0)
        result = 31 * result + (subtype?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uuid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageVirtualMachine

        if (activeDirectoryConfiguration != other.activeDirectoryConfiguration) return false
        if (creationTime != other.creationTime) return false
        if (endpoints != other.endpoints) return false
        if (fileSystemId != other.fileSystemId) return false
        if (lifecycle != other.lifecycle) return false
        if (lifecycleTransitionReason != other.lifecycleTransitionReason) return false
        if (name != other.name) return false
        if (resourceArn != other.resourceArn) return false
        if (rootVolumeSecurityStyle != other.rootVolumeSecurityStyle) return false
        if (storageVirtualMachineId != other.storageVirtualMachineId) return false
        if (subtype != other.subtype) return false
        if (tags != other.tags) return false
        if (uuid != other.uuid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.StorageVirtualMachine = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
         */
        public var activeDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SvmActiveDirectoryConfiguration? = null
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The endpoints that are used to access data or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They are the `Iscsi`, `Management`, `Nfs`, and `Smb` endpoints.
         */
        public var endpoints: aws.sdk.kotlin.services.fsx.model.SvmEndpoints? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * Describes the SVM's lifecycle status.
         * + `CREATED` - The SVM is fully available for use.
         * + `CREATING` - Amazon FSx is creating the new SVM.
         * + `DELETING` - Amazon FSx is deleting an existing SVM.
         * + `FAILED` - Amazon FSx was unable to create the SVM.
         * + `MISCONFIGURED` - The SVM is in a failed but recoverable state.
         * + `PENDING` - Amazon FSx has not started creating the SVM.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.StorageVirtualMachineLifecycle? = null
        /**
         * Describes why the SVM lifecycle state changed.
         */
        public var lifecycleTransitionReason: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason? = null
        /**
         * The name of the SVM, if provisioned.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The security style of the root volume of the SVM.
         */
        public var rootVolumeSecurityStyle: aws.sdk.kotlin.services.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle? = null
        /**
         * The SVM's system generated unique ID.
         */
        public var storageVirtualMachineId: kotlin.String? = null
        /**
         * Describes the SVM's subtype.
         */
        public var subtype: aws.sdk.kotlin.services.fsx.model.StorageVirtualMachineSubtype? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * The SVM's UUID (universally unique identifier).
         */
        public var uuid: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.StorageVirtualMachine) : this() {
            this.activeDirectoryConfiguration = x.activeDirectoryConfiguration
            this.creationTime = x.creationTime
            this.endpoints = x.endpoints
            this.fileSystemId = x.fileSystemId
            this.lifecycle = x.lifecycle
            this.lifecycleTransitionReason = x.lifecycleTransitionReason
            this.name = x.name
            this.resourceArn = x.resourceArn
            this.rootVolumeSecurityStyle = x.rootVolumeSecurityStyle
            this.storageVirtualMachineId = x.storageVirtualMachineId
            this.subtype = x.subtype
            this.tags = x.tags
            this.uuid = x.uuid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.StorageVirtualMachine = StorageVirtualMachine(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SvmActiveDirectoryConfiguration] inside the given [block]
         */
        public fun activeDirectoryConfiguration(block: aws.sdk.kotlin.services.fsx.model.SvmActiveDirectoryConfiguration.Builder.() -> kotlin.Unit) {
            this.activeDirectoryConfiguration = aws.sdk.kotlin.services.fsx.model.SvmActiveDirectoryConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SvmEndpoints] inside the given [block]
         */
        public fun endpoints(block: aws.sdk.kotlin.services.fsx.model.SvmEndpoints.Builder.() -> kotlin.Unit) {
            this.endpoints = aws.sdk.kotlin.services.fsx.model.SvmEndpoints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason] inside the given [block]
         */
        public fun lifecycleTransitionReason(block: aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason.Builder.() -> kotlin.Unit) {
            this.lifecycleTransitionReason = aws.sdk.kotlin.services.fsx.model.LifecycleTransitionReason.invoke(block)
        }
    }
}
