// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
 *
 * Valid tiering policies are the following:
 * + `SNAPSHOT_ONLY` - (Default value) moves cold snapshots to the capacity pool storage tier.
 *
 * + `AUTO` - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.
 *
 * + `ALL` - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.
 *
 * + `NONE` - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.
 */
public class TieringPolicy private constructor(builder: Builder) {
    /**
     * Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with the `AUTO` and `SNAPSHOT_ONLY` tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
     */
    public val coolingPeriod: kotlin.Int? = builder.coolingPeriod
    /**
     * Specifies the tiering policy used to transition data. Default value is `SNAPSHOT_ONLY`.
     * + `SNAPSHOT_ONLY` - moves cold snapshots to the capacity pool storage tier.
     * + `AUTO` - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.
     * + `ALL` - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.
     * + `NONE` - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.
     */
    public val name: aws.sdk.kotlin.services.fsx.model.TieringPolicyName? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.TieringPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TieringPolicy(")
        append("coolingPeriod=$coolingPeriod,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = coolingPeriod ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TieringPolicy

        if (coolingPeriod != other.coolingPeriod) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.TieringPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with the `AUTO` and `SNAPSHOT_ONLY` tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
         */
        public var coolingPeriod: kotlin.Int? = null
        /**
         * Specifies the tiering policy used to transition data. Default value is `SNAPSHOT_ONLY`.
         * + `SNAPSHOT_ONLY` - moves cold snapshots to the capacity pool storage tier.
         * + `AUTO` - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.
         * + `ALL` - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.
         * + `NONE` - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.
         */
        public var name: aws.sdk.kotlin.services.fsx.model.TieringPolicyName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.TieringPolicy) : this() {
            this.coolingPeriod = x.coolingPeriod
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.TieringPolicy = TieringPolicy(this)
    }
}
