// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



public class UpdateDataRepositoryAssociationRequest private constructor(builder: Builder) {
    /**
     * The ID of the data repository association that you are updating.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     *
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
     */
    public val importedFileChunkSize: kotlin.Int? = builder.importedFileChunkSize
    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     */
    public val s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = builder.s3

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDataRepositoryAssociationRequest(")
        append("associationId=$associationId,")
        append("clientRequestToken=$clientRequestToken,")
        append("importedFileChunkSize=$importedFileChunkSize,")
        append("s3=$s3)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (importedFileChunkSize ?: 0)
        result = 31 * result + (s3?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDataRepositoryAssociationRequest

        if (associationId != other.associationId) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (importedFileChunkSize != other.importedFileChunkSize) return false
        if (s3 != other.s3) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the data repository association that you are updating.
         */
        public var associationId: kotlin.String? = null
        /**
         * (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         *
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         */
        public var importedFileChunkSize: kotlin.Int? = null
        /**
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
         */
        public var s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationRequest) : this() {
            this.associationId = x.associationId
            this.clientRequestToken = x.clientRequestToken
            this.importedFileChunkSize = x.importedFileChunkSize
            this.s3 = x.s3
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationRequest = UpdateDataRepositoryAssociationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration] inside the given [block]
         */
        public fun s3(block: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.Builder.() -> kotlin.Unit) {
            this.s3 = aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.invoke(block)
        }
    }
}
