// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * The request object for the `UpdateFileSystem` operation.
 */
public class UpdateFileSystemRequest private constructor(builder: Builder) {
    /**
     * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The ID of the file system that you are updating.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The configuration object for Amazon FSx for Lustre file systems used in the `UpdateFileSystem` operation.
     */
    public val lustreConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration? = builder.lustreConfiguration
    /**
     * The configuration updates for an Amazon FSx for NetApp ONTAP file system.
     */
    public val ontapConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration? = builder.ontapConfiguration
    /**
     * The configuration updates for an Amazon FSx for OpenZFS file system.
     */
    public val openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOpenZfsConfiguration? = builder.openZfsConfiguration
    /**
     * Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server, Amazon FSx for Lustre, or Amazon FSx for NetApp ONTAP file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity for the file system that you're updating.
     *
     * You can't make a storage capacity increase request if there is an existing storage capacity increase request in progress.
     *
     * For Windows file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of throughput capacity. For more information, see [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html) in the *Amazon FSx for Windows File Server User Guide*.
     *
     * For Lustre file systems, the storage capacity target value can be the following:
     * + For `SCRATCH_2`, `PERSISTENT_1`, and `PERSISTENT_2 SSD` deployment types, valid values are in multiples of 2400 GiB. The value must be greater than the current storage capacity.
     * + For `PERSISTENT HDD` file systems, valid values are multiples of 6000 GiB for 12-MBps throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must be greater than the current storage capacity.
     * + For `SCRATCH_1` file systems, you can't increase the storage capacity.
     *
     * For more information, see [Managing storage and throughput capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html) in the *Amazon FSx for Lustre User Guide*.
     *
     * For ONTAP file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. For more information, see [Managing storage capacity and provisioned IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
     */
    public val storageCapacity: kotlin.Int? = builder.storageCapacity
    /**
     * The configuration updates for an Amazon FSx for Windows File Server file system.
     */
    public val windowsConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration? = builder.windowsConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("fileSystemId=$fileSystemId,")
        append("lustreConfiguration=$lustreConfiguration,")
        append("ontapConfiguration=$ontapConfiguration,")
        append("openZfsConfiguration=$openZfsConfiguration,")
        append("storageCapacity=$storageCapacity,")
        append("windowsConfiguration=$windowsConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (lustreConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ontapConfiguration?.hashCode() ?: 0)
        result = 31 * result + (openZfsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageCapacity ?: 0)
        result = 31 * result + (windowsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (fileSystemId != other.fileSystemId) return false
        if (lustreConfiguration != other.lustreConfiguration) return false
        if (ontapConfiguration != other.ontapConfiguration) return false
        if (openZfsConfiguration != other.openZfsConfiguration) return false
        if (storageCapacity != other.storageCapacity) return false
        if (windowsConfiguration != other.windowsConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The ID of the file system that you are updating.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The configuration object for Amazon FSx for Lustre file systems used in the `UpdateFileSystem` operation.
         */
        public var lustreConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration? = null
        /**
         * The configuration updates for an Amazon FSx for NetApp ONTAP file system.
         */
        public var ontapConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration? = null
        /**
         * The configuration updates for an Amazon FSx for OpenZFS file system.
         */
        public var openZfsConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOpenZfsConfiguration? = null
        /**
         * Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server, Amazon FSx for Lustre, or Amazon FSx for NetApp ONTAP file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity for the file system that you're updating.
         *
         * You can't make a storage capacity increase request if there is an existing storage capacity increase request in progress.
         *
         * For Windows file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of throughput capacity. For more information, see [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html) in the *Amazon FSx for Windows File Server User Guide*.
         *
         * For Lustre file systems, the storage capacity target value can be the following:
         * + For `SCRATCH_2`, `PERSISTENT_1`, and `PERSISTENT_2 SSD` deployment types, valid values are in multiples of 2400 GiB. The value must be greater than the current storage capacity.
         * + For `PERSISTENT HDD` file systems, valid values are multiples of 6000 GiB for 12-MBps throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must be greater than the current storage capacity.
         * + For `SCRATCH_1` file systems, you can't increase the storage capacity.
         *
         * For more information, see [Managing storage and throughput capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html) in the *Amazon FSx for Lustre User Guide*.
         *
         * For ONTAP file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. For more information, see [Managing storage capacity and provisioned IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
         */
        public var storageCapacity: kotlin.Int? = null
        /**
         * The configuration updates for an Amazon FSx for Windows File Server file system.
         */
        public var windowsConfiguration: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.fileSystemId = x.fileSystemId
            this.lustreConfiguration = x.lustreConfiguration
            this.ontapConfiguration = x.ontapConfiguration
            this.openZfsConfiguration = x.openZfsConfiguration
            this.storageCapacity = x.storageCapacity
            this.windowsConfiguration = x.windowsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemRequest = UpdateFileSystemRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration] inside the given [block]
         */
        public fun lustreConfiguration(block: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration.Builder.() -> kotlin.Unit) {
            this.lustreConfiguration = aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration] inside the given [block]
         */
        public fun ontapConfiguration(block: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration.Builder.() -> kotlin.Unit) {
            this.ontapConfiguration = aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOpenZfsConfiguration] inside the given [block]
         */
        public fun openZfsConfiguration(block: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOpenZfsConfiguration.Builder.() -> kotlin.Unit) {
            this.openZfsConfiguration = aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOpenZfsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration] inside the given [block]
         */
        public fun windowsConfiguration(block: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration.Builder.() -> kotlin.Unit) {
            this.windowsConfiguration = aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration.invoke(block)
        }
    }
}
