// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model



/**
 * Used to specify changes to the ONTAP configuration for the volume you are updating.
 */
public class UpdateOntapVolumeConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the location in the SVM's namespace where the volume is mounted. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
     */
    public val junctionPath: kotlin.String? = builder.junctionPath
    /**
     * The security style for the volume, which can be `UNIX`. `NTFS`, or `MIXED`.
     */
    public val securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = builder.securityStyle
    /**
     * Specifies the size of the volume in megabytes.
     */
    public val sizeInMegabytes: kotlin.Int? = builder.sizeInMegabytes
    /**
     * Default is `false`. Set to true to enable the deduplication, compression, and compaction storage efficiency features on the volume.
     */
    public val storageEfficiencyEnabled: kotlin.Boolean? = builder.storageEfficiencyEnabled
    /**
     * Update the volume's data tiering policy.
     */
    public val tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = builder.tieringPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOntapVolumeConfiguration(")
        append("junctionPath=$junctionPath,")
        append("securityStyle=$securityStyle,")
        append("sizeInMegabytes=$sizeInMegabytes,")
        append("storageEfficiencyEnabled=$storageEfficiencyEnabled,")
        append("tieringPolicy=$tieringPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = junctionPath?.hashCode() ?: 0
        result = 31 * result + (securityStyle?.hashCode() ?: 0)
        result = 31 * result + (sizeInMegabytes ?: 0)
        result = 31 * result + (storageEfficiencyEnabled?.hashCode() ?: 0)
        result = 31 * result + (tieringPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOntapVolumeConfiguration

        if (junctionPath != other.junctionPath) return false
        if (securityStyle != other.securityStyle) return false
        if (sizeInMegabytes != other.sizeInMegabytes) return false
        if (storageEfficiencyEnabled != other.storageEfficiencyEnabled) return false
        if (tieringPolicy != other.tieringPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the location in the SVM's namespace where the volume is mounted. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
         */
        public var junctionPath: kotlin.String? = null
        /**
         * The security style for the volume, which can be `UNIX`. `NTFS`, or `MIXED`.
         */
        public var securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = null
        /**
         * Specifies the size of the volume in megabytes.
         */
        public var sizeInMegabytes: kotlin.Int? = null
        /**
         * Default is `false`. Set to true to enable the deduplication, compression, and compaction storage efficiency features on the volume.
         */
        public var storageEfficiencyEnabled: kotlin.Boolean? = null
        /**
         * Update the volume's data tiering policy.
         */
        public var tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration) : this() {
            this.junctionPath = x.junctionPath
            this.securityStyle = x.securityStyle
            this.sizeInMegabytes = x.sizeInMegabytes
            this.storageEfficiencyEnabled = x.storageEfficiencyEnabled
            this.tieringPolicy = x.tieringPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateOntapVolumeConfiguration = UpdateOntapVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.TieringPolicy] inside the given [block]
         */
        public fun tieringPolicy(block: aws.sdk.kotlin.services.fsx.model.TieringPolicy.Builder.() -> kotlin.Unit) {
            this.tieringPolicy = aws.sdk.kotlin.services.fsx.model.TieringPolicy.invoke(block)
        }
    }
}
