// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fsx.model.CancelDataRepositoryTaskResponse
import aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskLifecycle
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CancelDataRepositoryTaskOperationDeserializer: HttpDeserialize<CancelDataRepositoryTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CancelDataRepositoryTaskResponse {
        if (!response.status.isSuccess()) {
            throwCancelDataRepositoryTaskError(context, response)
        }
        val builder = CancelDataRepositoryTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCancelDataRepositoryTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCancelDataRepositoryTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "DataRepositoryTaskEnded" -> DataRepositoryTaskEndedDeserializer().deserialize(context, wrappedResponse)
        "DataRepositoryTaskNotFound" -> DataRepositoryTaskNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedResponse)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCancelDataRepositoryTaskOperationBody(builder: CancelDataRepositoryTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Lifecycle"))
    val TASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLE_DESCRIPTOR)
        field(TASKID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeString().let { DataRepositoryTaskLifecycle.fromValue(it) }
                TASKID_DESCRIPTOR.index -> builder.taskId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
