// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreConfiguration
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemOpenZfsConfiguration
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration
import aws.sdk.kotlin.services.fsx.model.FileSystemType
import aws.sdk.kotlin.services.fsx.model.StorageType
import aws.sdk.kotlin.services.fsx.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFileSystemOperationSerializer: HttpSerialize<CreateFileSystemRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateFileSystemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateFileSystemOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateFileSystemOperationBody(context: ExecutionContext, input: CreateFileSystemRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val FILESYSTEMTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemType"))
    val FILESYSTEMTYPEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemTypeVersion"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LUSTRECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LustreConfiguration"))
    val ONTAPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OntapConfiguration"))
    val OPENZFSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OpenZFSConfiguration"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityGroupIds"))
    val STORAGECAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StorageCapacity"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StorageType"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val WINDOWSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WindowsConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(FILESYSTEMTYPE_DESCRIPTOR)
        field(FILESYSTEMTYPEVERSION_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LUSTRECONFIGURATION_DESCRIPTOR)
        field(ONTAPCONFIGURATION_DESCRIPTOR)
        field(OPENZFSCONFIGURATION_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(STORAGECAPACITY_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(WINDOWSCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.fileSystemType?.let { field(FILESYSTEMTYPE_DESCRIPTOR, it.value) }
        input.fileSystemTypeVersion?.let { field(FILESYSTEMTYPEVERSION_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.lustreConfiguration?.let { field(LUSTRECONFIGURATION_DESCRIPTOR, it, ::serializeCreateFileSystemLustreConfigurationDocument) }
        input.ontapConfiguration?.let { field(ONTAPCONFIGURATION_DESCRIPTOR, it, ::serializeCreateFileSystemOntapConfigurationDocument) }
        input.openZfsConfiguration?.let { field(OPENZFSCONFIGURATION_DESCRIPTOR, it, ::serializeCreateFileSystemOpenZfsConfigurationDocument) }
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        input.storageCapacity?.let { field(STORAGECAPACITY_DESCRIPTOR, it) }
        input.storageType?.let { field(STORAGETYPE_DESCRIPTOR, it.value) }
        if (input.subnetIds != null) {
            listField(SUBNETIDS_DESCRIPTOR) {
                for (el0 in input.subnetIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.windowsConfiguration?.let { field(WINDOWSCONFIGURATION_DESCRIPTOR, it, ::serializeCreateFileSystemWindowsConfigurationDocument) }
    }
    return serializer.toByteArray()
}
