// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemLustreResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemWindowsResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.sdk.kotlin.services.fsx.model.FileSystemLifecycle
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteFileSystemOperationDeserializer: HttpDeserialize<DeleteFileSystemResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteFileSystemResponse {
        if (!response.status.isSuccess()) {
            throwDeleteFileSystemError(context, response)
        }
        val builder = DeleteFileSystemResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteFileSystemOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteFileSystemError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedResponse)
        "IncompatibleParameterError" -> IncompatibleParameterErrorDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "ServiceLimitExceeded" -> ServiceLimitExceededDeserializer().deserialize(context, wrappedResponse)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteFileSystemOperationBody(builder: DeleteFileSystemResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemId"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Lifecycle"))
    val LUSTRERESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LustreResponse"))
    val OPENZFSRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OpenZFSResponse"))
    val WINDOWSRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WindowsResponse"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILESYSTEMID_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
        field(LUSTRERESPONSE_DESCRIPTOR)
        field(OPENZFSRESPONSE_DESCRIPTOR)
        field(WINDOWSRESPONSE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FILESYSTEMID_DESCRIPTOR.index -> builder.fileSystemId = deserializeString()
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeString().let { FileSystemLifecycle.fromValue(it) }
                LUSTRERESPONSE_DESCRIPTOR.index -> builder.lustreResponse = deserializeDeleteFileSystemLustreResponseDocument(deserializer)
                OPENZFSRESPONSE_DESCRIPTOR.index -> builder.openZfsResponse = deserializeDeleteFileSystemOpenZfsResponseDocument(deserializer)
                WINDOWSRESPONSE_DESCRIPTOR.index -> builder.windowsResponse = deserializeDeleteFileSystemWindowsResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
