// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryAssociationsResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeDataRepositoryAssociationsOperationDeserializer: HttpDeserialize<DescribeDataRepositoryAssociationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDataRepositoryAssociationsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDataRepositoryAssociationsError(context, response)
        }
        val builder = DescribeDataRepositoryAssociationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDataRepositoryAssociationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDataRepositoryAssociationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "DataRepositoryAssociationNotFound" -> DataRepositoryAssociationNotFoundDeserializer().deserialize(context, wrappedResponse)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidDataRepositoryType" -> InvalidDataRepositoryTypeDeserializer().deserialize(context, wrappedResponse)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDataRepositoryAssociationsOperationBody(builder: DescribeDataRepositoryAssociationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Associations"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSOCIATIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSOCIATIONS_DESCRIPTOR.index -> builder.associations =
                    deserializer.deserializeList(ASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DataRepositoryAssociation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataRepositoryAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
