// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fsx.model.DataRepositoryTask
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryTasksResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeDataRepositoryTasksOperationDeserializer: HttpDeserialize<DescribeDataRepositoryTasksResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDataRepositoryTasksResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDataRepositoryTasksError(context, response)
        }
        val builder = DescribeDataRepositoryTasksResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDataRepositoryTasksOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDataRepositoryTasksError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "DataRepositoryTaskNotFound" -> DataRepositoryTaskNotFoundDeserializer().deserialize(context, wrappedResponse)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDataRepositoryTasksOperationBody(builder: DescribeDataRepositoryTasksResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATAREPOSITORYTASKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DataRepositoryTasks"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATAREPOSITORYTASKS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATAREPOSITORYTASKS_DESCRIPTOR.index -> builder.dataRepositoryTasks =
                    deserializer.deserializeList(DATAREPOSITORYTASKS_DESCRIPTOR) {
                        val col0 = mutableListOf<DataRepositoryTask>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataRepositoryTaskDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
