// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fsx.model.DescribeStorageVirtualMachinesResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.sdk.kotlin.services.fsx.model.StorageVirtualMachine
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeStorageVirtualMachinesOperationDeserializer: HttpDeserialize<DescribeStorageVirtualMachinesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeStorageVirtualMachinesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeStorageVirtualMachinesError(context, response)
        }
        val builder = DescribeStorageVirtualMachinesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeStorageVirtualMachinesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeStorageVirtualMachinesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "StorageVirtualMachineNotFound" -> StorageVirtualMachineNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStorageVirtualMachinesOperationBody(builder: DescribeStorageVirtualMachinesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STORAGEVIRTUALMACHINES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("StorageVirtualMachines"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(STORAGEVIRTUALMACHINES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STORAGEVIRTUALMACHINES_DESCRIPTOR.index -> builder.storageVirtualMachines =
                    deserializer.deserializeList(STORAGEVIRTUALMACHINES_DESCRIPTOR) {
                        val col0 = mutableListOf<StorageVirtualMachine>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStorageVirtualMachineDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
