// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.sdk.kotlin.services.fsx.model.RestoreVolumeFromSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.VolumeLifecycle
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RestoreVolumeFromSnapshotOperationDeserializer: HttpDeserialize<RestoreVolumeFromSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RestoreVolumeFromSnapshotResponse {
        if (!response.status.isSuccess()) {
            throwRestoreVolumeFromSnapshotError(context, response)
        }
        val builder = RestoreVolumeFromSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRestoreVolumeFromSnapshotOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRestoreVolumeFromSnapshotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "VolumeNotFound" -> VolumeNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreVolumeFromSnapshotOperationBody(builder: RestoreVolumeFromSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Lifecycle"))
    val VOLUMEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VolumeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLE_DESCRIPTOR)
        field(VOLUMEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeString().let { VolumeLifecycle.fromValue(it) }
                VOLUMEID_DESCRIPTOR.index -> builder.volumeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
