// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.sdk.kotlin.services.fsx.model.TagResourceResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class TagResourceOperationDeserializer: HttpDeserialize<TagResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TagResourceResponse {
        if (!response.status.isSuccess()) {
            throwTagResourceError(context, response)
        }
        val builder = TagResourceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwTagResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "NotServiceResourceError" -> NotServiceResourceErrorDeserializer().deserialize(context, wrappedResponse)
        "ResourceDoesNotSupportTagging" -> ResourceDoesNotSupportTaggingDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
