// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Temporary access credentials used for uploading game build files to Amazon GameLift. They are valid for a limited time. If they expire before you upload your game build, get a new set by calling RequestUploadCredentials.
 */
public class AwsCredentials private constructor(builder: Builder) {
    /**
     * Temporary key allowing access to the Amazon GameLift S3 account.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * Temporary secret key allowing access to the Amazon GameLift S3 account.
     */
    public val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * Token used to associate a specific build ID with the files uploaded using these credentials.
     */
    public val sessionToken: kotlin.String? = builder.sessionToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.AwsCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCredentials(")
        append("accessKeyId=$accessKeyId,")
        append("secretAccessKey=$secretAccessKey,")
        append("sessionToken=$sessionToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (sessionToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCredentials

        if (accessKeyId != other.accessKeyId) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.AwsCredentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Temporary key allowing access to the Amazon GameLift S3 account.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * Temporary secret key allowing access to the Amazon GameLift S3 account.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * Token used to associate a specific build ID with the files uploaded using these credentials.
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.AwsCredentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.AwsCredentials = AwsCredentials(this)
    }
}
