// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the returned data in response to a request operation.
 */
public class CreateBuildResponse private constructor(builder: Builder) {
    /**
     * The newly created build resource, including a unique build IDs and status.
     */
    public val build: aws.sdk.kotlin.services.gamelift.model.Build? = builder.build
    /**
     * Amazon S3 location for your game build file, including bucket name and key.
     */
    public val storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = builder.storageLocation
    /**
     * This element is returned only when the operation is called without a storage location. It contains credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have a limited life span. To refresh these credentials, call RequestUploadCredentials.
     */
    public val uploadCredentials: aws.sdk.kotlin.services.gamelift.model.AwsCredentials? = builder.uploadCredentials

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateBuildResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBuildResponse(")
        append("build=$build,")
        append("storageLocation=$storageLocation,")
        append("uploadCredentials=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = build?.hashCode() ?: 0
        result = 31 * result + (storageLocation?.hashCode() ?: 0)
        result = 31 * result + (uploadCredentials?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBuildResponse

        if (build != other.build) return false
        if (storageLocation != other.storageLocation) return false
        if (uploadCredentials != other.uploadCredentials) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateBuildResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The newly created build resource, including a unique build IDs and status.
         */
        public var build: aws.sdk.kotlin.services.gamelift.model.Build? = null
        /**
         * Amazon S3 location for your game build file, including bucket name and key.
         */
        public var storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = null
        /**
         * This element is returned only when the operation is called without a storage location. It contains credentials to use when you are uploading a build file to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have a limited life span. To refresh these credentials, call RequestUploadCredentials.
         */
        public var uploadCredentials: aws.sdk.kotlin.services.gamelift.model.AwsCredentials? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateBuildResponse) : this() {
            this.build = x.build
            this.storageLocation = x.storageLocation
            this.uploadCredentials = x.uploadCredentials
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateBuildResponse = CreateBuildResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.Build] inside the given [block]
         */
        public fun build(block: aws.sdk.kotlin.services.gamelift.model.Build.Builder.() -> kotlin.Unit) {
            this.build = aws.sdk.kotlin.services.gamelift.model.Build.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.S3Location] inside the given [block]
         */
        public fun storageLocation(block: aws.sdk.kotlin.services.gamelift.model.S3Location.Builder.() -> kotlin.Unit) {
            this.storageLocation = aws.sdk.kotlin.services.gamelift.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.AwsCredentials] inside the given [block]
         */
        public fun uploadCredentials(block: aws.sdk.kotlin.services.gamelift.model.AwsCredentials.Builder.() -> kotlin.Unit) {
            this.uploadCredentials = aws.sdk.kotlin.services.gamelift.model.AwsCredentials.invoke(block)
        }
    }
}
