// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the returned data in response to a request operation.
 */
public class CreateFleetLocationsResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet that was updated with new locations.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The remote locations that are being added to the fleet, and the life-cycle status of each location. For new locations, the status is set to `NEW`. During location creation, GameLift updates each location's status as instances are deployed there and prepared for game hosting. This list does not include the fleet home Region or any remote locations that were already added to the fleet.
     */
    public val locationStates: List<LocationState>? = builder.locationStates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateFleetLocationsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFleetLocationsResponse(")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("locationStates=$locationStates)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetArn?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (locationStates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFleetLocationsResponse

        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (locationStates != other.locationStates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateFleetLocationsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet that was updated with new locations.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The remote locations that are being added to the fleet, and the life-cycle status of each location. For new locations, the status is set to `NEW`. During location creation, GameLift updates each location's status as instances are deployed there and prepared for game hosting. This list does not include the fleet home Region or any remote locations that were already added to the fleet.
         */
        public var locationStates: List<LocationState>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateFleetLocationsResponse) : this() {
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.locationStates = x.locationStates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateFleetLocationsResponse = CreateFleetLocationsResponse(this)
    }
}
