// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
public class CreateFleetRequest private constructor(builder: Builder) {
    /**
     * The unique identifier for a custom game server build to be deployed on fleet instances. You can use either the build ID or ARN. The build must be uploaded to GameLift and in `READY` status. This fleet property cannot be changed later.
     */
    public val buildId: kotlin.String? = builder.buildId
    /**
     * Prompts GameLift to generate a TLS/SSL certificate for the fleet. TLS certificates are used for encrypting traffic between game clients and the game servers that are running on GameLift. By default, the `CertificateConfiguration` is set to `DISABLED`. This property cannot be changed after the fleet is created.
     *
     * Note: This feature requires the Amazon Web Services Certificate Manager (ACM) service, which is not available in all Amazon Web Services regions. When working in a region that does not support this feature, a fleet creation request with certificate generation fails with a 4xx error.
     */
    public val certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = builder.certificateConfiguration
    /**
     * A human-readable description of the fleet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
     */
    public val ec2InboundPermissions: List<IpPermission>? = builder.ec2InboundPermissions
    /**
     * The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions of Amazon EC2 instance types.
     */
    public val ec2InstanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.ec2InstanceType
    /**
     * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to `ON_DEMAND`. Learn more about when to use [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). This property cannot be changed after the fleet is created.
     */
    public val fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = builder.fleetType
    /**
     * A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the [IAM dashboard](https://console.aws.amazon.com/iam/) in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at [ Access external resources from a game server](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html). This property cannot be changed after the fleet is created.
     */
    public val instanceRoleArn: kotlin.String? = builder.instanceRoleArn
    /**
     * A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter can only be used when creating fleets in Amazon Web Services Regions that support multiple locations. You can add any GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web Services Region code such as `us-west-2`. To create a fleet with instances in the home Region only, omit this parameter.
     */
    public val locations: List<LocationConfiguration>? = builder.locations
    /**
     * **This parameter is no longer used.** To specify where GameLift should store log files once a server process shuts down, use the GameLift server API `ProcessReady()` and specify one or more directory paths in `logParameters`. See more information in the [Server API Reference](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
     */
    public val logPaths: List<String>? = builder.logPaths
    /**
     * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time.
     */
    public val metricGroups: List<String>? = builder.metricGroups
    /**
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of termination protection for active game sessions on the fleet. By default, this property is set to `NoProtection`. You can also set game session protection for an individual game session by calling UpdateGameSession.
     * + **NoProtection** - Game sessions can be terminated during active gameplay as a result of a scale-down event.
     * + **FullProtection** - Game sessions in `ACTIVE` status cannot be terminated during a scale-down event.
     */
    public val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * Used when peering your GameLift fleet with a VPC, the unique identifier for the Amazon Web Services account that owns the VPC. You can find your account ID in the Amazon Web Services Management Console under account settings.
     */
    public val peerVpcAwsAccountId: kotlin.String? = builder.peerVpcAwsAccountId
    /**
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the [VPC Dashboard](https://console.aws.amazon.com/vpc/) in the Amazon Web Services Management Console. Learn more about VPC peering in [VPC Peering with GameLift Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
     */
    public val peerVpcId: kotlin.String? = builder.peerVpcId
    /**
     * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
     */
    public val resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = builder.resourceCreationLimitPolicy
    /**
     * Instructions for how to launch and maintain server processes on instances in the fleet. The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently.
     *
     * The `RuntimeConfiguration` parameter is required unless the fleet is being configured using the older parameters `ServerLaunchPath` and `ServerLaunchParameters`, which are still supported for backward compatibility.
     */
    public val runtimeConfiguration: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration? = builder.runtimeConfiguration
    /**
     * The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property cannot be changed later.
     */
    public val scriptId: kotlin.String? = builder.scriptId
    /**
     * **This parameter is no longer used.** Specify server launch parameters using the `RuntimeConfiguration` parameter. Requests that use this parameter instead continue to be valid.
     */
    public val serverLaunchParameters: kotlin.String? = builder.serverLaunchParameters
    /**
     * **This parameter is no longer used.** Specify a server launch path using the `RuntimeConfiguration` parameter. Requests that use this parameter instead continue to be valid.
     */
    public val serverLaunchPath: kotlin.String? = builder.serverLaunchPath
    /**
     * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*. Once the fleet is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the *Amazon Web Services General Reference* for actual tagging limits.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFleetRequest(")
        append("buildId=$buildId,")
        append("certificateConfiguration=$certificateConfiguration,")
        append("description=$description,")
        append("ec2InboundPermissions=$ec2InboundPermissions,")
        append("ec2InstanceType=$ec2InstanceType,")
        append("fleetType=$fleetType,")
        append("instanceRoleArn=$instanceRoleArn,")
        append("locations=$locations,")
        append("logPaths=$logPaths,")
        append("metricGroups=$metricGroups,")
        append("name=$name,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("peerVpcAwsAccountId=$peerVpcAwsAccountId,")
        append("peerVpcId=$peerVpcId,")
        append("resourceCreationLimitPolicy=$resourceCreationLimitPolicy,")
        append("runtimeConfiguration=$runtimeConfiguration,")
        append("scriptId=$scriptId,")
        append("serverLaunchParameters=$serverLaunchParameters,")
        append("serverLaunchPath=$serverLaunchPath,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildId?.hashCode() ?: 0
        result = 31 * result + (certificateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ec2InboundPermissions?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceType?.hashCode() ?: 0)
        result = 31 * result + (fleetType?.hashCode() ?: 0)
        result = 31 * result + (instanceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (locations?.hashCode() ?: 0)
        result = 31 * result + (logPaths?.hashCode() ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (peerVpcAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (peerVpcId?.hashCode() ?: 0)
        result = 31 * result + (resourceCreationLimitPolicy?.hashCode() ?: 0)
        result = 31 * result + (runtimeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scriptId?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchParameters?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchPath?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFleetRequest

        if (buildId != other.buildId) return false
        if (certificateConfiguration != other.certificateConfiguration) return false
        if (description != other.description) return false
        if (ec2InboundPermissions != other.ec2InboundPermissions) return false
        if (ec2InstanceType != other.ec2InstanceType) return false
        if (fleetType != other.fleetType) return false
        if (instanceRoleArn != other.instanceRoleArn) return false
        if (locations != other.locations) return false
        if (logPaths != other.logPaths) return false
        if (metricGroups != other.metricGroups) return false
        if (name != other.name) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (peerVpcAwsAccountId != other.peerVpcAwsAccountId) return false
        if (peerVpcId != other.peerVpcId) return false
        if (resourceCreationLimitPolicy != other.resourceCreationLimitPolicy) return false
        if (runtimeConfiguration != other.runtimeConfiguration) return false
        if (scriptId != other.scriptId) return false
        if (serverLaunchParameters != other.serverLaunchParameters) return false
        if (serverLaunchPath != other.serverLaunchPath) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for a custom game server build to be deployed on fleet instances. You can use either the build ID or ARN. The build must be uploaded to GameLift and in `READY` status. This fleet property cannot be changed later.
         */
        public var buildId: kotlin.String? = null
        /**
         * Prompts GameLift to generate a TLS/SSL certificate for the fleet. TLS certificates are used for encrypting traffic between game clients and the game servers that are running on GameLift. By default, the `CertificateConfiguration` is set to `DISABLED`. This property cannot be changed after the fleet is created.
         *
         * Note: This feature requires the Amazon Web Services Certificate Manager (ACM) service, which is not available in all Amazon Web Services regions. When working in a region that does not support this feature, a fleet creation request with certificate generation fails with a 4xx error.
         */
        public var certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = null
        /**
         * A human-readable description of the fleet.
         */
        public var description: kotlin.String? = null
        /**
         * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         */
        public var ec2InboundPermissions: List<IpPermission>? = null
        /**
         * The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions of Amazon EC2 instance types.
         */
        public var ec2InstanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null
        /**
         * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to `ON_DEMAND`. Learn more about when to use [ On-Demand versus Spot Instances](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot). This property cannot be changed after the fleet is created.
         */
        public var fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = null
        /**
         * A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the [IAM dashboard](https://console.aws.amazon.com/iam/) in the Amazon Web Services Management Console. Learn more about using on-box credentials for your game servers at [ Access external resources from a game server](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html). This property cannot be changed after the fleet is created.
         */
        public var instanceRoleArn: kotlin.String? = null
        /**
         * A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter can only be used when creating fleets in Amazon Web Services Regions that support multiple locations. You can add any GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web Services Region code such as `us-west-2`. To create a fleet with instances in the home Region only, omit this parameter.
         */
        public var locations: List<LocationConfiguration>? = null
        /**
         * **This parameter is no longer used.** To specify where GameLift should store log files once a server process shuts down, use the GameLift server API `ProcessReady()` and specify one or more directory paths in `logParameters`. See more information in the [Server API Reference](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
         */
        public var logPaths: List<String>? = null
        /**
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time.
         */
        public var metricGroups: List<String>? = null
        /**
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The status of termination protection for active game sessions on the fleet. By default, this property is set to `NoProtection`. You can also set game session protection for an individual game session by calling UpdateGameSession.
         * + **NoProtection** - Game sessions can be terminated during active gameplay as a result of a scale-down event.
         * + **FullProtection** - Game sessions in `ACTIVE` status cannot be terminated during a scale-down event.
         */
        public var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * Used when peering your GameLift fleet with a VPC, the unique identifier for the Amazon Web Services account that owns the VPC. You can find your account ID in the Amazon Web Services Management Console under account settings.
         */
        public var peerVpcAwsAccountId: kotlin.String? = null
        /**
         * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the [VPC Dashboard](https://console.aws.amazon.com/vpc/) in the Amazon Web Services Management Console. Learn more about VPC peering in [VPC Peering with GameLift Fleets](https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
         */
        public var peerVpcId: kotlin.String? = null
        /**
         * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
         */
        public var resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = null
        /**
         * Instructions for how to launch and maintain server processes on instances in the fleet. The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently.
         *
         * The `RuntimeConfiguration` parameter is required unless the fleet is being configured using the older parameters `ServerLaunchPath` and `ServerLaunchParameters`, which are still supported for backward compatibility.
         */
        public var runtimeConfiguration: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration? = null
        /**
         * The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property cannot be changed later.
         */
        public var scriptId: kotlin.String? = null
        /**
         * **This parameter is no longer used.** Specify server launch parameters using the `RuntimeConfiguration` parameter. Requests that use this parameter instead continue to be valid.
         */
        public var serverLaunchParameters: kotlin.String? = null
        /**
         * **This parameter is no longer used.** Specify a server launch path using the `RuntimeConfiguration` parameter. Requests that use this parameter instead continue to be valid.
         */
        public var serverLaunchPath: kotlin.String? = null
        /**
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*. Once the fleet is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the *Amazon Web Services General Reference* for actual tagging limits.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest) : this() {
            this.buildId = x.buildId
            this.certificateConfiguration = x.certificateConfiguration
            this.description = x.description
            this.ec2InboundPermissions = x.ec2InboundPermissions
            this.ec2InstanceType = x.ec2InstanceType
            this.fleetType = x.fleetType
            this.instanceRoleArn = x.instanceRoleArn
            this.locations = x.locations
            this.logPaths = x.logPaths
            this.metricGroups = x.metricGroups
            this.name = x.name
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.peerVpcAwsAccountId = x.peerVpcAwsAccountId
            this.peerVpcId = x.peerVpcId
            this.resourceCreationLimitPolicy = x.resourceCreationLimitPolicy
            this.runtimeConfiguration = x.runtimeConfiguration
            this.scriptId = x.scriptId
            this.serverLaunchParameters = x.serverLaunchParameters
            this.serverLaunchPath = x.serverLaunchPath
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest = CreateFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration] inside the given [block]
         */
        public fun certificateConfiguration(block: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.Builder.() -> kotlin.Unit) {
            this.certificateConfiguration = aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy] inside the given [block]
         */
        public fun resourceCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.resourceCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration] inside the given [block]
         */
        public fun runtimeConfiguration(block: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration.Builder.() -> kotlin.Unit) {
            this.runtimeConfiguration = aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration.invoke(block)
        }
    }
}
