// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



public class CreateGameServerGroupRequest private constructor(builder: Builder) {
    /**
     * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. The scaling policy uses the metric `"PercentUtilizedGameServers"` to maintain a buffer of idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
     */
    public val autoScalingPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy? = builder.autoScalingPolicy
    /**
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:
     * + `SPOT_ONLY` - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.
     * + `SPOT_PREFERRED` - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.
     * + `ON_DEMAND_ONLY` - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.
     */
    public val balancingStrategy: aws.sdk.kotlin.services.gamelift.model.BalancingStrategy? = builder.balancingStrategy
    /**
     * An identifier for the new game server group. This value is used to generate unique ARN identifiers for the Amazon EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region per Amazon Web Services account.
     */
    public val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is set to `NO_PROTECTION` by default.
     */
    public val gameServerProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerProtectionPolicy? = builder.gameServerProtectionPolicy
    /**
     * The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. For more information on instance types, see [EC2 Instance Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide*. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see [ Instance Weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html) in the Amazon EC2 Auto Scaling User Guide.
     */
    public val instanceDefinitions: List<InstanceDefinition>? = builder.instanceDefinitions
    /**
     * The Amazon EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. You can specify the template using either the template name or ID. For help with creating a launch template, see [Creating a Launch Template for an Auto Scaling Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon Elastic Compute Cloud Auto Scaling User Guide*. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
     *
     * If you specify network interfaces in your launch template, you must explicitly set the property `AssociatePublicIpAddress` to "true". If no network interface is specified in the launch template, GameLift FleetIQ uses your account's default VPC.
     */
    public val launchTemplate: aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The maximum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and Amazon EC2 do not scale down the group below this minimum. In production, this value should be set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources is useful for resource management, access management, and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*. Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags, respectively. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that you've set up. This property cannot be updated after the game server group is created, and the corresponding Auto Scaling group will always use the property value that is set with this request, even if the Auto Scaling group is updated directly.
     */
    public val vpcSubnets: List<String>? = builder.vpcSubnets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateGameServerGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGameServerGroupRequest(")
        append("autoScalingPolicy=$autoScalingPolicy,")
        append("balancingStrategy=$balancingStrategy,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerProtectionPolicy=$gameServerProtectionPolicy,")
        append("instanceDefinitions=$instanceDefinitions,")
        append("launchTemplate=$launchTemplate,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("vpcSubnets=$vpcSubnets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingPolicy?.hashCode() ?: 0
        result = 31 * result + (balancingStrategy?.hashCode() ?: 0)
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (instanceDefinitions?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGameServerGroupRequest

        if (autoScalingPolicy != other.autoScalingPolicy) return false
        if (balancingStrategy != other.balancingStrategy) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerProtectionPolicy != other.gameServerProtectionPolicy) return false
        if (instanceDefinitions != other.instanceDefinitions) return false
        if (launchTemplate != other.launchTemplate) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (vpcSubnets != other.vpcSubnets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateGameServerGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. The scaling policy uses the metric `"PercentUtilizedGameServers"` to maintain a buffer of idle game servers that can immediately accommodate new games and players. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
         */
        public var autoScalingPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy? = null
        /**
         * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group. Method options include the following:
         * + `SPOT_ONLY` - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.
         * + `SPOT_PREFERRED` - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.
         * + `ON_DEMAND_ONLY` - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.
         */
        public var balancingStrategy: aws.sdk.kotlin.services.gamelift.model.BalancingStrategy? = null
        /**
         * An identifier for the new game server group. This value is used to generate unique ARN identifiers for the Amazon EC2 Auto Scaling group and the GameLift FleetIQ game server group. The name must be unique per Region per Amazon Web Services account.
         */
        public var gameServerGroupName: kotlin.String? = null
        /**
         * A flag that indicates whether instances in the game server group are protected from early termination. Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by Amazon Web Services regardless of protection status. This property is set to `NO_PROTECTION` by default.
         */
        public var gameServerProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerProtectionPolicy? = null
        /**
         * The Amazon EC2 instance types and sizes to use in the Auto Scaling group. The instance definitions must specify at least two different instance types that are supported by GameLift FleetIQ. For more information on instance types, see [EC2 Instance Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide*. You can optionally specify capacity weighting for each instance type. If no weight value is specified for an instance type, it is set to the default value "1". For more information about capacity weighting, see [ Instance Weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html) in the Amazon EC2 Auto Scaling User Guide.
         */
        public var instanceDefinitions: List<InstanceDefinition>? = null
        /**
         * The Amazon EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. You can specify the template using either the template name or ID. For help with creating a launch template, see [Creating a Launch Template for an Auto Scaling Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon Elastic Compute Cloud Auto Scaling User Guide*. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
         *
         * If you specify network interfaces in your launch template, you must explicitly set the property `AssociatePublicIpAddress` to "true". If no network interface is specified in the launch template, GameLift FleetIQ uses your account's default VPC.
         */
        public var launchTemplate: aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification? = null
        /**
         * The maximum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum number of instances allowed in the Amazon EC2 Auto Scaling group. During automatic scaling events, GameLift FleetIQ and Amazon EC2 do not scale down the group below this minimum. In production, this value should be set to at least 1. After the Auto Scaling group is created, update this value directly in the Auto Scaling group using the Amazon Web Services console or APIs.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto Scaling groups.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of labels to assign to the new game server group resource. Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources is useful for resource management, access management, and cost allocation. For more information, see [ Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*. Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags, respectively. The maximum tag limit may be lower than stated. See the Amazon Web Services General Reference for actual tagging limits.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of virtual private cloud (VPC) subnets to use with instances in the game server group. By default, all GameLift FleetIQ-supported Availability Zones are used. You can use this parameter to specify VPCs that you've set up. This property cannot be updated after the game server group is created, and the corresponding Auto Scaling group will always use the property value that is set with this request, even if the Auto Scaling group is updated directly.
         */
        public var vpcSubnets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateGameServerGroupRequest) : this() {
            this.autoScalingPolicy = x.autoScalingPolicy
            this.balancingStrategy = x.balancingStrategy
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerProtectionPolicy = x.gameServerProtectionPolicy
            this.instanceDefinitions = x.instanceDefinitions
            this.launchTemplate = x.launchTemplate
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.vpcSubnets = x.vpcSubnets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateGameServerGroupRequest = CreateGameServerGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy] inside the given [block]
         */
        public fun autoScalingPolicy(block: aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy.Builder.() -> kotlin.Unit) {
            this.autoScalingPolicy = aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification.invoke(block)
        }
    }
}
