// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
public class DescribeScalingPoliciesRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the fleet for which to retrieve scaling policies. You can use either the fleet ID or ARN value.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The fleet location. If you don't specify this value, the response contains the scaling policies of every location in the fleet.
     */
    public val location: kotlin.String? = builder.location
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Scaling policy status to filter results on. A scaling policy is only in force when in an `ACTIVE` status.
     * + **ACTIVE** -- The scaling policy is currently in force.
     * + **UPDATEREQUESTED** -- A request to update the scaling policy has been received.
     * + **UPDATING** -- A change is being made to the scaling policy.
     * + **DELETEREQUESTED** -- A request to delete the scaling policy has been received.
     * + **DELETING** -- The scaling policy is being deleted.
     * + **DELETED** -- The scaling policy has been deleted.
     * + **ERROR** -- An error occurred in creating the policy. It should be removed and recreated.
     */
    public val statusFilter: aws.sdk.kotlin.services.gamelift.model.ScalingStatusType? = builder.statusFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScalingPoliciesRequest(")
        append("fleetId=$fleetId,")
        append("limit=$limit,")
        append("location=$location,")
        append("nextToken=$nextToken,")
        append("statusFilter=$statusFilter)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (statusFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeScalingPoliciesRequest

        if (fleetId != other.fleetId) return false
        if (limit != other.limit) return false
        if (location != other.location) return false
        if (nextToken != other.nextToken) return false
        if (statusFilter != other.statusFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the fleet for which to retrieve scaling policies. You can use either the fleet ID or ARN value.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
         */
        public var limit: kotlin.Int? = null
        /**
         * The fleet location. If you don't specify this value, the response contains the scaling policies of every location in the fleet.
         */
        public var location: kotlin.String? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Scaling policy status to filter results on. A scaling policy is only in force when in an `ACTIVE` status.
         * + **ACTIVE** -- The scaling policy is currently in force.
         * + **UPDATEREQUESTED** -- A request to update the scaling policy has been received.
         * + **UPDATING** -- A change is being made to the scaling policy.
         * + **DELETEREQUESTED** -- A request to delete the scaling policy has been received.
         * + **DELETING** -- The scaling policy is being deleted.
         * + **DELETED** -- The scaling policy has been deleted.
         * + **ERROR** -- An error occurred in creating the policy. It should be removed and recreated.
         */
        public var statusFilter: aws.sdk.kotlin.services.gamelift.model.ScalingStatusType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesRequest) : this() {
            this.fleetId = x.fleetId
            this.limit = x.limit
            this.location = x.location
            this.nextToken = x.nextToken
            this.statusFilter = x.statusFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesRequest = DescribeScalingPoliciesRequest(this)
    }
}
