// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * The GameLift service limits for an Amazon EC2 instance type and current utilization. GameLift allows Amazon Web Services accounts a maximum number of instances, per instance type, per Amazon Web Services Region or location, for use with GameLift. You can request an limit increase for your account by using the **Service limits** page in the GameLift console.
 *
 * **Related actions**
 *
 * DescribeEC2InstanceLimits
 */
public class Ec2InstanceLimit private constructor(builder: Builder) {
    /**
     * The number of instances for the specified type and location that are currently being used by the Amazon Web Services account.
     */
    public val currentInstances: kotlin.Int? = builder.currentInstances
    /**
     * The name of an Amazon EC2 instance type. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
     */
    public val ec2InstanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.ec2InstanceType
    /**
     * The number of instances that is allowed for the specified instance type and location.
     */
    public val instanceLimit: kotlin.Int? = builder.instanceLimit
    /**
     * An Amazon Web Services Region code, such as `us-west-2`.
     */
    public val location: kotlin.String? = builder.location

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceLimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2InstanceLimit(")
        append("currentInstances=$currentInstances,")
        append("ec2InstanceType=$ec2InstanceType,")
        append("instanceLimit=$instanceLimit,")
        append("location=$location)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentInstances ?: 0
        result = 31 * result + (ec2InstanceType?.hashCode() ?: 0)
        result = 31 * result + (instanceLimit ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2InstanceLimit

        if (currentInstances != other.currentInstances) return false
        if (ec2InstanceType != other.ec2InstanceType) return false
        if (instanceLimit != other.instanceLimit) return false
        if (location != other.location) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceLimit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of instances for the specified type and location that are currently being used by the Amazon Web Services account.
         */
        public var currentInstances: kotlin.Int? = null
        /**
         * The name of an Amazon EC2 instance type. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
         */
        public var ec2InstanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null
        /**
         * The number of instances that is allowed for the specified instance type and location.
         */
        public var instanceLimit: kotlin.Int? = null
        /**
         * An Amazon Web Services Region code, such as `us-west-2`.
         */
        public var location: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceLimit) : this() {
            this.currentInstances = x.currentInstances
            this.ec2InstanceType = x.ec2InstanceType
            this.instanceLimit = x.instanceLimit
            this.location = x.location
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceLimit = Ec2InstanceLimit(this)
    }
}
