// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
 *
 * **Related actions**
 *
 * [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) | [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) | [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
 */
public class FleetCapacity private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet associated with the location.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The current instance count and capacity settings for the fleet location.
     */
    public val instanceCounts: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts? = builder.instanceCounts
    /**
     * The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the computing resources in use, including CPU, memory, storage, and networking capacity. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
     */
    public val instanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.instanceType
    /**
     * The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as `us-west-2`.
     */
    public val location: kotlin.String? = builder.location

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.FleetCapacity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetCapacity(")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("instanceCounts=$instanceCounts,")
        append("instanceType=$instanceType,")
        append("location=$location)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetArn?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (instanceCounts?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetCapacity

        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (instanceCounts != other.instanceCounts) return false
        if (instanceType != other.instanceType) return false
        if (location != other.location) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.FleetCapacity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet associated with the location.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The current instance count and capacity settings for the fleet location.
         */
        public var instanceCounts: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts? = null
        /**
         * The Amazon EC2 instance type that is used for all instances in a fleet. The instance type determines the computing resources in use, including CPU, memory, storage, and networking capacity. See [Amazon Elastic Compute Cloud Instance Types](http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
         */
        public var instanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null
        /**
         * The fleet location for the instance count information, expressed as an Amazon Web Services Region code, such as `us-west-2`.
         */
        public var location: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.FleetCapacity) : this() {
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.instanceCounts = x.instanceCounts
            this.instanceType = x.instanceType
            this.location = x.location
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.FleetCapacity = FleetCapacity(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts] inside the given [block]
         */
        public fun instanceCounts(block: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts.Builder.() -> kotlin.Unit) {
            this.instanceCounts = aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts.invoke(block)
        }
    }
}
