// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * **This data type is used with the GameLift FleetIQ and game server groups.**
 *
 * Properties describing a game server that is running on an instance in a GameServerGroup.
 *
 * A game server is created by a successful call to `RegisterGameServer` and deleted by calling `DeregisterGameServer`. A game server is claimed to host a game session by calling `ClaimGameServer`.
 *
 * **Related actions**
 *
 * RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer | UpdateGameServer | DeregisterGameServer | [All APIs by task](https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html)
 */
public class GameServer private constructor(builder: Builder) {
    /**
     * Indicates when an available game server has been reserved for gameplay but has not yet started hosting a game. Once it is claimed, the game server remains in `CLAIMED` status for a maximum of one minute. During this time, game clients connect to the game server to start the game and trigger the game server to update its utilization status. After one minute, the game server claim status reverts to null.
     */
    public val claimStatus: aws.sdk.kotlin.services.gamelift.model.GameServerClaimStatus? = builder.claimStatus
    /**
     * The port and IP address that must be used to establish a client connection to the game server.
     */
    public val connectionInfo: kotlin.String? = builder.connectionInfo
    /**
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer.
     */
    public val gameServerData: kotlin.String? = builder.gameServerData
    /**
     * The ARN identifier for the game server group where the game server is located.
     */
    public val gameServerGroupArn: kotlin.String? = builder.gameServerGroupArn
    /**
     * A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
     */
    public val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A custom string that uniquely identifies the game server. Game server IDs are developer-defined and are unique across all game server groups in an Amazon Web Services account.
     */
    public val gameServerId: kotlin.String? = builder.gameServerId
    /**
     * The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: `i-1234567890abcdef0`.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Timestamp that indicates the last time the game server was claimed with a ClaimGameServer request. The format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`). This value is used to calculate when a claimed game server's status should revert to null.
     */
    public val lastClaimTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastClaimTime
    /**
     * Timestamp that indicates the last time the game server was updated with health status using an UpdateGameServer request. The format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`). After game server registration, this property is only changed when a game server update specifies a health check value.
     */
    public val lastHealthCheckTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastHealthCheckTime
    /**
     * Timestamp that indicates when the game server was created with a RegisterGameServer request. The format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val registrationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.registrationTime
    /**
     * Indicates whether the game server is currently available for new games or is busy. Possible statuses include:
     * + `AVAILABLE` - The game server is available to be claimed. A game server that has been claimed remains in this status until it reports game hosting activity.
     * + `UTILIZED` - The game server is currently hosting a game session with players.
     */
    public val utilizationStatus: aws.sdk.kotlin.services.gamelift.model.GameServerUtilizationStatus? = builder.utilizationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameServer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameServer(")
        append("claimStatus=$claimStatus,")
        append("connectionInfo=$connectionInfo,")
        append("gameServerData=$gameServerData,")
        append("gameServerGroupArn=$gameServerGroupArn,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerId=$gameServerId,")
        append("instanceId=$instanceId,")
        append("lastClaimTime=$lastClaimTime,")
        append("lastHealthCheckTime=$lastHealthCheckTime,")
        append("registrationTime=$registrationTime,")
        append("utilizationStatus=$utilizationStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = claimStatus?.hashCode() ?: 0
        result = 31 * result + (connectionInfo?.hashCode() ?: 0)
        result = 31 * result + (gameServerData?.hashCode() ?: 0)
        result = 31 * result + (gameServerGroupArn?.hashCode() ?: 0)
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (lastClaimTime?.hashCode() ?: 0)
        result = 31 * result + (lastHealthCheckTime?.hashCode() ?: 0)
        result = 31 * result + (registrationTime?.hashCode() ?: 0)
        result = 31 * result + (utilizationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameServer

        if (claimStatus != other.claimStatus) return false
        if (connectionInfo != other.connectionInfo) return false
        if (gameServerData != other.gameServerData) return false
        if (gameServerGroupArn != other.gameServerGroupArn) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerId != other.gameServerId) return false
        if (instanceId != other.instanceId) return false
        if (lastClaimTime != other.lastClaimTime) return false
        if (lastHealthCheckTime != other.lastHealthCheckTime) return false
        if (registrationTime != other.registrationTime) return false
        if (utilizationStatus != other.utilizationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameServer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates when an available game server has been reserved for gameplay but has not yet started hosting a game. Once it is claimed, the game server remains in `CLAIMED` status for a maximum of one minute. During this time, game clients connect to the game server to start the game and trigger the game server to update its utilization status. After one minute, the game server claim status reverts to null.
         */
        public var claimStatus: aws.sdk.kotlin.services.gamelift.model.GameServerClaimStatus? = null
        /**
         * The port and IP address that must be used to establish a client connection to the game server.
         */
        public var connectionInfo: kotlin.String? = null
        /**
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer.
         */
        public var gameServerData: kotlin.String? = null
        /**
         * The ARN identifier for the game server group where the game server is located.
         */
        public var gameServerGroupArn: kotlin.String? = null
        /**
         * A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
         */
        public var gameServerGroupName: kotlin.String? = null
        /**
         * A custom string that uniquely identifies the game server. Game server IDs are developer-defined and are unique across all game server groups in an Amazon Web Services account.
         */
        public var gameServerId: kotlin.String? = null
        /**
         * The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: `i-1234567890abcdef0`.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Timestamp that indicates the last time the game server was claimed with a ClaimGameServer request. The format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`). This value is used to calculate when a claimed game server's status should revert to null.
         */
        public var lastClaimTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Timestamp that indicates the last time the game server was updated with health status using an UpdateGameServer request. The format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`). After game server registration, this property is only changed when a game server update specifies a health check value.
         */
        public var lastHealthCheckTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Timestamp that indicates when the game server was created with a RegisterGameServer request. The format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var registrationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the game server is currently available for new games or is busy. Possible statuses include:
         * + `AVAILABLE` - The game server is available to be claimed. A game server that has been claimed remains in this status until it reports game hosting activity.
         * + `UTILIZED` - The game server is currently hosting a game session with players.
         */
        public var utilizationStatus: aws.sdk.kotlin.services.gamelift.model.GameServerUtilizationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameServer) : this() {
            this.claimStatus = x.claimStatus
            this.connectionInfo = x.connectionInfo
            this.gameServerData = x.gameServerData
            this.gameServerGroupArn = x.gameServerGroupArn
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerId = x.gameServerId
            this.instanceId = x.instanceId
            this.lastClaimTime = x.lastClaimTime
            this.lastHealthCheckTime = x.lastHealthCheckTime
            this.registrationTime = x.registrationTime
            this.utilizationStatus = x.utilizationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameServer = GameServer(this)
    }
}
